/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.route.impl.algms;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.jplugin.core.das.dds.api.TablesplitException;
import net.jplugin.core.das.route.api.DataSourceInfo;
import net.jplugin.core.das.route.api.ITsAlgorithm;
import net.jplugin.core.das.route.api.RouterDataSource;
import net.jplugin.core.das.route.api.RouterDataSourceConfig;
import net.jplugin.core.das.route.api.RouterKeyFilter;

public class HashAlgm
implements ITsAlgorithm {
    ConcurrentHashMap<String, DataSourceInfo[]> allTablesCache = new ConcurrentHashMap();

    @Override
    public ITsAlgorithm.Result getResult(RouterDataSource compondDataSource, String tableBaseName, ITsAlgorithm.ValueType vt, Object key) {
        int splits;
        long hashCode;
        if (vt == ITsAlgorithm.ValueType.LONG) {
            hashCode = (Long)key;
        } else if (key instanceof String) {
            hashCode = key.toString().hashCode();
        } else {
            throw new RuntimeException("not support algm for key java type:" + key.getClass().getName() + " algm is: " + this.getClass().getName());
        }
        if (hashCode < 0L) {
            hashCode = -hashCode;
        }
        if ((splits = compondDataSource.getConfig().findTableConfig(tableBaseName).getSplits()) == 0) {
            throw new TablesplitException("Splits value error ,must >0 ,for table:" + tableBaseName);
        }
        int mod = (int)(hashCode % (long)splits);
        int dsIndex = mod % compondDataSource.getConfig().getDataSourceConfig().length;
        ITsAlgorithm.Result r = ITsAlgorithm.Result.create();
        r.setDataSource(compondDataSource.getConfig().getDataSourceConfig()[dsIndex].getDataSrouceCfgName());
        r.setTableName(tableBaseName + "_" + (mod + 1));
        return r;
    }

    @Override
    public DataSourceInfo[] getMultiResults(RouterDataSource compondDataSource, String tableBaseName, ITsAlgorithm.ValueType valueType, RouterKeyFilter kva) {
        if (RouterKeyFilter.Operator.EQUAL.equals((Object)kva.getOperator())) {
            ITsAlgorithm.Result r = this.getResult(compondDataSource, tableBaseName, valueType, kva.getConstValue()[0]);
            DataSourceInfo[] ret = new DataSourceInfo[]{DataSourceInfo.build(r.getDataSource(), r.getTableName())};
            return ret;
        }
        if (RouterKeyFilter.Operator.IN.equals((Object)kva.getOperator())) {
            DataSourceInfo[] ret = this.getFromValueList(compondDataSource, tableBaseName, valueType, kva.getConstValue());
            return ret;
        }
        return this.getAllTables(compondDataSource, tableBaseName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSourceInfo[] getAllTables(RouterDataSource compondDataSource, String tableBaseName) {
        String key = compondDataSource.getDataSourceName() + "#" + tableBaseName;
        DataSourceInfo[] result = this.allTablesCache.get(key);
        if (result == null) {
            HashAlgm hashAlgm = this;
            synchronized (hashAlgm) {
                result = this.allTablesCache.get(key);
                if (result == null) {
                    RouterDataSourceConfig.TableConfig tableCfg = compondDataSource.getConfig().findTableConfig(tableBaseName);
                    int splits = tableCfg.getSplits();
                    Object[] valueList = new Object[splits];
                    for (int i = 0; i < splits; ++i) {
                        valueList[i] = (long)i;
                    }
                    result = this.getFromValueList(compondDataSource, tableBaseName, ITsAlgorithm.ValueType.LONG, valueList);
                    this.allTablesCache.put(key, result);
                }
            }
        }
        return result;
    }

    private DataSourceInfo[] getFromValueList(RouterDataSource compondDataSource, String tableBaseName, ITsAlgorithm.ValueType valueType, Object[] values) {
        HashMap resultsMap = new HashMap();
        for (int i = 0; i < values.length; ++i) {
            ITsAlgorithm.Result r = this.getResult(compondDataSource, tableBaseName, valueType, values[i]);
            HashSet<String> targetList = (HashSet<String>)resultsMap.get(r.getDataSource());
            if (targetList == null) {
                targetList = new HashSet<String>();
                resultsMap.put(r.getDataSource(), targetList);
            }
            if (targetList.contains(r.getTableName())) continue;
            targetList.add(r.getTableName());
        }
        DataSourceInfo[] ret = new DataSourceInfo[resultsMap.size()];
        int i = 0;
        for (Map.Entry en : resultsMap.entrySet()) {
            String[] tbs = new String[((Set)en.getValue()).size()];
            ret[i++] = DataSourceInfo.build((String)en.getKey(), ((Set)en.getValue()).toArray(tbs));
        }
        return ret;
    }
}

