/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.route.impl.algms;

import java.time.temporal.ChronoUnit;
import java.util.TimeZone;
import net.jplugin.common.kits.CalenderKit;
import net.jplugin.core.das.route.api.DataSourceInfo;
import net.jplugin.core.das.route.api.ITsAlgorithm;
import net.jplugin.core.das.route.api.RouterDataSource;
import net.jplugin.core.das.route.api.RouterDataSourceConfig;
import net.jplugin.core.das.route.api.RouterKeyFilter;
import net.jplugin.core.das.route.impl.algms.TimeBasedSpanUtil;
import net.jplugin.core.das.route.impl.algms.TimeConverterKit;

public class DateAlgm
implements ITsAlgorithm {
    private int trackDays = 14;
    private static int offset = TimeZone.getDefault().getRawOffset();

    protected void setTrackDays(int m) {
        this.trackDays = m;
    }

    @Override
    public ITsAlgorithm.Result getResult(RouterDataSource compondDataSource, String tableBaseName, ITsAlgorithm.ValueType vt, Object key) {
        long time = TimeConverterKit.convertToTimeLong(vt, key);
        int dayIndex = this.computeDayIndex(time);
        RouterDataSourceConfig.DataSourceConfig[] dsConfig = compondDataSource.getConfig().getDataSourceConfig();
        int dsIndex = dayIndex % dsConfig.length;
        ITsAlgorithm.Result r = ITsAlgorithm.Result.create();
        r.setDataSource(dsConfig[dsIndex].getDataSrouceCfgName());
        r.setTableName(this.getTableName(tableBaseName, time));
        return r;
    }

    private int computeDayIndex(long time) {
        return (int)((time + (long)offset) / 86400000L);
    }

    private String getTableName(String tableBaseName, long time) {
        return tableBaseName + "_" + CalenderKit.getShortDateString(time);
    }

    @Override
    public DataSourceInfo[] getMultiResults(RouterDataSource dataSource, String tableName, ITsAlgorithm.ValueType valueType, RouterKeyFilter kva) {
        return TimeBasedSpanUtil.getResults(this, dataSource, tableName, valueType, kva, ChronoUnit.DAYS, this.trackDays);
    }
}

