/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.route.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import net.jplugin.core.das.dds.api.RouterException;
import net.jplugin.core.das.dds.api.TablesplitException;
import net.jplugin.core.das.route.Plugin;
import net.jplugin.core.das.route.api.DataSourceInfo;
import net.jplugin.core.das.route.api.ITsAlgorithm;
import net.jplugin.core.das.route.api.RouterDataSource;
import net.jplugin.core.das.route.api.RouterDataSourceConfig;
import net.jplugin.core.das.route.api.RouterKeyFilter;
import net.jplugin.core.kernel.api.PluginEnvirement;

public class TsAlgmManager {
    private static Map<String, ITsAlgorithm> algmMap = new HashMap<String, ITsAlgorithm>();
    private static ThreadLocal<KeyTypeValueRespect> valueRespect = new ThreadLocal<KeyTypeValueRespect>(){

        @Override
        protected KeyTypeValueRespect initialValue() {
            return new KeyTypeValueRespect();
        }
    };

    public static DataSourceInfo[] getMultiResults(RouterDataSource dataSource, String tableName, RouterKeyFilter kva) {
        RouterDataSourceConfig.TableConfig tc = dataSource.getConfig().findTableConfig(tableName);
        ITsAlgorithm algm = algmMap.get(tc.getSplitAlgm());
        ITsAlgorithm.ValueType type = TsAlgmManager.checkAndConvertKeyValue(kva);
        if (algm == null) {
            throw new TablesplitException("error algm:" + tc.getSplitAlgm() + " for table:" + tableName);
        }
        DataSourceInfo[] result = algm.getMultiResults(dataSource, tableName, type, kva);
        return result;
    }

    private static ITsAlgorithm.ValueType checkAndConvertKeyValue(RouterKeyFilter kva) {
        Object[] vals = kva.getConstValue();
        ITsAlgorithm.ValueType type = null;
        if (vals != null) {
            for (int i = 0; i < vals.length; ++i) {
                Object o = vals[i];
                if (o == null) continue;
                KeyTypeValueRespect r = TsAlgmManager.convertValueRespect(o);
                vals[i] = r.value;
                if (type != null) {
                    if (type.equals((Object)r.valueType)) continue;
                    throw new RouterException("All the values in the sql must be same type. " + (Object)((Object)type) + " " + (Object)((Object)r.valueType));
                }
                type = r.valueType;
            }
        }
        return type;
    }

    public static DataSourceInfo[] getDataSourceInfos(RouterDataSource dataSource, String tableName) {
        return TsAlgmManager.getMultiResults(dataSource, tableName, new RouterKeyFilter(RouterKeyFilter.Operator.ALL, null));
    }

    public static ITsAlgorithm.Result getResult(RouterDataSource compondDataSource, String tbBaseName, Object key) {
        RouterDataSourceConfig.TableConfig tc = compondDataSource.getConfig().findTableConfig(tbBaseName);
        ITsAlgorithm algm = algmMap.get(tc.getSplitAlgm());
        if (algm == null) {
            throw new TablesplitException("error algm:" + tc.getSplitAlgm() + " for table:" + tbBaseName);
        }
        KeyTypeValueRespect vr = TsAlgmManager.convertValueRespect(key);
        ITsAlgorithm.Result result = algm.getResult(compondDataSource, tbBaseName, vr.getValueType(), vr.getValue());
        return result;
    }

    private static KeyTypeValueRespect convertValueRespect(Object key) {
        KeyTypeValueRespect o = valueRespect.get();
        if (key instanceof String) {
            o.setValue(key);
            o.setValueType(ITsAlgorithm.ValueType.STRING);
        } else if (key instanceof Integer) {
            o.setValue((Integer)key);
            o.setValueType(ITsAlgorithm.ValueType.LONG);
        } else if (key instanceof Long) {
            o.setValue((Long)key);
            o.setValueType(ITsAlgorithm.ValueType.LONG);
        } else if (key instanceof BigDecimal) {
            o.setValue(((BigDecimal)key).longValue());
            o.setValueType(ITsAlgorithm.ValueType.LONG);
        } else if (key instanceof BigInteger) {
            o.setValue(((BigInteger)key).longValue());
            o.setValueType(ITsAlgorithm.ValueType.LONG);
        } else if (key instanceof Date) {
            o.setValue(key);
            o.setValueType(ITsAlgorithm.ValueType.DATE);
        } else if (key instanceof Timestamp) {
            o.setValue(key);
            o.setValueType(ITsAlgorithm.ValueType.TIMESTAMP);
        } else {
            throw new TablesplitException("not supported key value type:" + key + " " + key.getClass().getName());
        }
        return o;
    }

    public static void init() {
        Map<String, Object> m = PluginEnvirement.getInstance().getExtensionMap(Plugin.EP_TS_ALGM);
        for (Map.Entry<String, Object> en : m.entrySet()) {
            algmMap.put(en.getKey(), (ITsAlgorithm)en.getValue());
        }
    }

    public static boolean exists(String algm) {
        return algmMap.containsKey(algm);
    }

    static class KeyTypeValueRespect {
        ITsAlgorithm.ValueType valueType;
        Object value;

        KeyTypeValueRespect() {
        }

        public ITsAlgorithm.ValueType getValueType() {
            return this.valueType;
        }

        public void setValueType(ITsAlgorithm.ValueType valueType) {
            this.valueType = valueType;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

