/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.route.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import net.jplugin.common.kits.StringKit;
import net.jplugin.core.das.api.DataSourceFactory;
import net.jplugin.core.das.api.IResultDisposer;
import net.jplugin.core.das.api.SQLTemplate;
import net.jplugin.core.das.dds.api.TablesplitException;
import net.jplugin.core.das.route.api.RouterDataSourceConfig;

public class TableAutoCreation {
    static ConcurrentHashMap<String, Long> tableMapping = new ConcurrentHashMap();
    private static final Long EXISTS_FLAG = 1L;
    private static final Long REPLAT_CHECK_NOTEXISTS_TABLE_INTERVAL = 180000L;

    public static void clearCache() {
        tableMapping.clear();
    }

    public static boolean checkExists(RouterDataSourceConfig.TableConfig tc, String dataSource, String tableName) {
        return TableAutoCreation.doCheck(dataSource, tableName, null, null, false);
    }

    public static boolean checkExistsAndCreate(RouterDataSourceConfig.TableConfig tc, String dataSource, String tableName, String tbBaseName) {
        String sql = tc.getCreationSql();
        if (StringKit.isNotNull(sql)) {
            return TableAutoCreation.doCheck(dataSource, tableName, tbBaseName, sql, true);
        }
        return TableAutoCreation.doCheck(dataSource, tableName, tbBaseName, sql, false);
    }

    private static synchronized boolean doCheck(String dataSource, String tableName, String baseTbName, String sql, boolean createIfNotExist) {
        String key = dataSource + "#" + tableName;
        Long flag = tableMapping.get(key);
        if (EXISTS_FLAG.equals(flag)) {
            return true;
        }
        if (!createIfNotExist && flag != null && System.currentTimeMillis() - flag <= REPLAT_CHECK_NOTEXISTS_TABLE_INTERVAL) {
            return false;
        }
        DataSource ds = DataSourceFactory.getDataSource(dataSource);
        try {
            Connection conn = ds.getConnection();
            try {
                SQLTemplate.executeSelect(conn, "select * from " + tableName + " where 1=2", new IResultDisposer(){

                    @Override
                    public void readRow(ResultSet rs) throws SQLException {
                    }
                }, null);
                tableMapping.put(key, EXISTS_FLAG);
                return true;
            }
            catch (Exception e1) {
                if (createIfNotExist) {
                    String finalSql = StringKit.repaceFirstIgnoreCase(sql, baseTbName, tableName);
                    SQLTemplate.executeCreateSql(conn, finalSql);
                    tableMapping.put(key, EXISTS_FLAG);
                    return true;
                }
                tableMapping.put(key, System.currentTimeMillis());
                return false;
            }
        }
        catch (Exception e) {
            throw new TablesplitException(e);
        }
    }
}

