/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.route.impl;

import net.jplugin.common.kits.AttributedObject;
import net.jplugin.core.das.dds.kits.SqlParserKit;
import net.jplugin.core.das.route.api.DataSourceInfo;
import net.jplugin.core.das.route.impl.conn.mulqry.CombinedSqlParser;
import net.jplugin.core.das.route.impl.conn.mulqry.rswrapper.WrapperManager;
import net.jplugin.core.kernel.api.ctx.ThreadLocalContext;
import net.jplugin.core.kernel.api.ctx.ThreadLocalContextManager;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.Select;

public class CombinedSelectContext
extends AttributedObject {
    private static final String COMBINED_SELECT_CONTEXT = "COMBINED_SELECT_CONTEXT";
    private String originalTableName;
    private DataSourceInfo[] dataSourceInfos;
    private String originalSql;
    private Select statement;
    private String finalSql;

    public static CombinedSelectContext makeContext(CombinedSqlParser.ParseResult pr) {
        CombinedSelectContext ctx = new CombinedSelectContext();
        String originalSql = pr.getSql();
        ctx.setOriginalSql(originalSql);
        ctx.setDataSourceInfos(pr.getMeta().getDataSourceInfos());
        ctx.setOriginalTableName(pr.getMeta().getSourceTb());
        Statement statement = SqlParserKit.parse(originalSql);
        ctx.setStatement((Select)statement);
        WrapperManager.INSTANCE.handleContextInitial(ctx);
        ctx.setFinalSql(ctx.getStatement().toString());
        CombinedSelectContext.set(ctx);
        return ctx;
    }

    public static CombinedSelectContext get() {
        ThreadLocalContext ctx = ThreadLocalContextManager.instance.getContext();
        return (CombinedSelectContext)ctx.getAttribute(COMBINED_SELECT_CONTEXT);
    }

    public static void set(CombinedSelectContext o) {
        ThreadLocalContext ctx = ThreadLocalContextManager.instance.getContext();
        ctx.setAttribute(COMBINED_SELECT_CONTEXT, o);
    }

    public String getOriginalSql() {
        return this.originalSql;
    }

    public void setOriginalSql(String originalSql) {
        this.originalSql = originalSql;
    }

    public Select getStatement() {
        return this.statement;
    }

    public void setStatement(Select statement) {
        this.statement = statement;
    }

    public String getFinalSql() {
        return this.finalSql;
    }

    public void setFinalSql(String finalSql) {
        this.finalSql = finalSql;
    }

    public DataSourceInfo[] getDataSourceInfos() {
        return this.dataSourceInfos;
    }

    public void setDataSourceInfos(DataSourceInfo[] dataSourceInfos) {
        this.dataSourceInfos = dataSourceInfos;
    }

    public String getOriginalTableName() {
        return this.originalTableName;
    }

    public void setOriginalTableName(String originalTableName) {
        this.originalTableName = originalTableName;
    }
}

