/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.route.function;

import java.util.HashMap;
import java.util.Map;
import net.jplugin.core.das.route.api.IAggregationFunctionHandler;
import net.jplugin.core.das.route.api.IFunctionHandler;
import net.jplugin.core.kernel.api.PluginEnvirement;

public class FunctionHandlerManager {
    public static FunctionHandlerManager INSTANCE = new FunctionHandlerManager();
    Map<String, IFunctionHandler> funcHandlers = new HashMap<String, IFunctionHandler>();
    Map<String, IAggregationFunctionHandler> aggFunctions;

    public void init() {
        this.aggFunctions = PluginEnvirement.getInstance().getExtensionMap("EP_SQL_AGG_FUNCTION", IAggregationFunctionHandler.class);
        this.funcHandlers = PluginEnvirement.getInstance().getExtensionMap("EP_SQL_FUNCTION", IFunctionHandler.class);
    }

    public IFunctionHandler getFunctionHandler(String name) {
        if (name == null) {
            return null;
        }
        IFunctionHandler f = this.funcHandlers.get(name);
        return f;
    }

    public IAggregationFunctionHandler getAggFunctionHandler(String name) {
        if (name == null) {
            return null;
        }
        IAggregationFunctionHandler f = this.aggFunctions.get(name);
        return f;
    }
}

