/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.route.api;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.jplugin.common.kits.StringKit;
import net.jplugin.core.das.api.DataSourceFactory;
import net.jplugin.core.das.route.impl.TsAlgmManager;

public class RouterDataSourceConfig {
    private static final Object PROP_DATA_SOURCE_NUM = "data-source-num";
    private static final Object PROP_COMMENT_REQUIRED_FOR_SPAN = "comment-required-for-span";
    private static final String DSC_PREFIX = "ds-";
    private static final String DS_NAME = "name";
    private static final String DS_WEIGHT = "weight";
    private static final Object PROP_TABLE_NUM = "table-num";
    private static final String TABLE_ALGM = "algm";
    private static final String TABLE_NAME = "name";
    private static final String TABLE_PREFIX = "tb-";
    private static final String TABLE_SPLITS = "splits";
    private static final String TABLE_KEY = "key";
    private static final String CREATION_SQL = "creation-sql";
    private static final String CREATION_BEFORE_DAYS = "creation-before-days";
    private static final String CREATION_AFTER_DAYS = "creation-after-days";
    private static final String PROP_ALLOWED_SCHEMAS = "allowed-schemas";
    private static final String PROP_ALLOW_NO_SCHEMA = "allow-no-schema";
    private DataSourceConfig[] dataSourceCfgs;
    private TableConfig[] tableConfigs;
    private Set<String> allowedSchemas;
    private boolean allowNoSchema = true;
    private boolean commentRequiredForSpan = false;

    public DataSourceConfig[] getDataSourceConfig() {
        return this.dataSourceCfgs;
    }

    public TableConfig[] getTableConfig() {
        return this.tableConfigs;
    }

    public Set<String> getAllowedSchemas() {
        return this.allowedSchemas;
    }

    public boolean isAllowNoSchema() {
        return this.allowNoSchema;
    }

    public boolean isCommentRequiredForSpan() {
        return this.commentRequiredForSpan;
    }

    public TableConfig findTableConfig(String tableBaseName) {
        for (TableConfig o : this.tableConfigs) {
            if (!tableBaseName.equalsIgnoreCase(o.getTableName())) continue;
            return o;
        }
        return null;
    }

    String trim(String s) {
        if (s == null) {
            return s;
        }
        return s.trim();
    }

    public void valid() {
        for (TableConfig tableConfig : this.tableConfigs) {
            if (TsAlgmManager.exists(tableConfig.splitAlgm)) continue;
            throw new RuntimeException("router datasource error, algm not exists:" + tableConfig.splitAlgm);
        }
        for (DataSourceConfig dataSourceConfig : this.dataSourceCfgs) {
            DataSourceFactory.getDataSource(dataSourceConfig.dataSourceName);
        }
    }

    public void fromProperties(Map<String, String> prop) {
        int i;
        String temp = this.trim(prop.get(PROP_DATA_SOURCE_NUM));
        if (temp != null) {
            temp = temp.trim();
        }
        if (StringKit.isNull(temp)) {
            throw new RuntimeException(PROP_DATA_SOURCE_NUM + " not configed");
        }
        int dataSourceNum = Integer.parseInt(temp);
        temp = this.trim(prop.get(PROP_TABLE_NUM));
        if (temp != null) {
            temp = temp.trim();
        }
        if (StringKit.isNull(temp)) {
            throw new RuntimeException(PROP_TABLE_NUM + " not configed");
        }
        int tableNum = Integer.parseInt(temp);
        temp = prop.get(PROP_ALLOWED_SCHEMAS);
        this.allowedSchemas = new HashSet<String>();
        if (temp != null) {
            String[] schemaNames;
            temp = temp.trim().toUpperCase();
            for (String as : schemaNames = StringKit.splitStr(temp, ",")) {
                this.allowedSchemas.add(as);
            }
        }
        if ((temp = prop.get(PROP_ALLOW_NO_SCHEMA)) != null) {
            temp = temp.trim();
        }
        if (StringKit.isNotNull(temp)) {
            this.allowNoSchema = Boolean.parseBoolean(temp);
        }
        if ((temp = prop.get(PROP_COMMENT_REQUIRED_FOR_SPAN)) != null) {
            temp = temp.trim();
        }
        if (StringKit.isNotNull(temp)) {
            this.commentRequiredForSpan = Boolean.parseBoolean(temp);
        }
        this.tableConfigs = new TableConfig[tableNum];
        for (i = 0; i < tableNum; ++i) {
            String tableName = this.trim(prop.get(TABLE_PREFIX + i + "-" + "name"));
            String algm = this.trim(prop.get(TABLE_PREFIX + i + "-" + TABLE_ALGM));
            String splits = this.trim(prop.get(TABLE_PREFIX + i + "-" + TABLE_SPLITS));
            String keyField = this.trim(prop.get(TABLE_PREFIX + i + "-" + TABLE_KEY));
            String creationSql = this.trim(prop.get(TABLE_PREFIX + i + "-" + CREATION_SQL));
            String creationBeforeDays = this.trim(prop.getOrDefault(TABLE_PREFIX + i + "-" + CREATION_BEFORE_DAYS, "-1"));
            String creationAfterDays = this.trim(prop.getOrDefault(TABLE_PREFIX + i + "-" + CREATION_AFTER_DAYS, "-1"));
            if (StringKit.isNull(tableName)) {
                throw new RuntimeException("router datasource error,tb-" + i + "-" + "name" + "  not found.");
            }
            if (StringKit.isNull(algm)) {
                throw new RuntimeException("router datasource error,tb-" + i + "-" + TABLE_ALGM + "  not found");
            }
            if (StringKit.isNull(splits)) {
                splits = "0";
            }
            if (StringKit.isNull(keyField)) {
                throw new RuntimeException("router datasource error,tb-" + i + "-" + TABLE_KEY + "  not found");
            }
            TableConfig tc = new TableConfig();
            tc.splitAlgm = algm;
            tc.tableName = tableName;
            tc.splits = Integer.parseInt(splits);
            tc.keyField = keyField;
            tc.creationSql = creationSql;
            tc.creationBeforeDays = Integer.parseInt(creationBeforeDays);
            tc.creationAfterDays = Integer.parseInt(creationAfterDays);
            this.tableConfigs[i] = tc;
        }
        this.dataSourceCfgs = new DataSourceConfig[dataSourceNum];
        for (i = 0; i < dataSourceNum; ++i) {
            String name = this.trim(prop.get(DSC_PREFIX + i + "-" + "name"));
            String snum = this.trim(prop.get(DSC_PREFIX + i + "-" + DS_WEIGHT));
            if (StringKit.isNull(name)) {
                throw new RuntimeException("router datasource error,ds-" + i + "-" + "name" + "  not found.");
            }
            if (StringKit.isNull(snum) && snum == null) {
                snum = "0";
            }
            int inum = Integer.parseInt(snum);
            DataSourceConfig dsc = new DataSourceConfig();
            dsc.dataSourceName = name;
            dsc.weight = inum;
            this.dataSourceCfgs[i] = dsc;
        }
    }

    public static class TableConfig {
        String tableName;
        String splitAlgm;
        int splits;
        String keyField;
        String creationSql;
        int creationBeforeDays;
        int creationAfterDays;

        public String getTableName() {
            return this.tableName;
        }

        public String getSplitAlgm() {
            return this.splitAlgm;
        }

        public int getSplits() {
            return this.splits;
        }

        public String getKeyField() {
            return this.keyField;
        }

        public String getCreationSql() {
            return this.creationSql;
        }

        public int getCreationBeforeDays() {
            return this.creationBeforeDays;
        }

        public int getCreationAfterDays() {
            return this.creationAfterDays;
        }
    }

    public static class DataSourceConfig {
        String dataSourceName;
        int weight;

        public String getDataSrouceCfgName() {
            return this.dataSourceName;
        }

        public int getWeight() {
            return this.weight;
        }
    }
}

