/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.route.api;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import net.jplugin.core.das.api.DataSourceFactory;
import net.jplugin.core.das.dds.api.AbstractRouterDataSource;
import net.jplugin.core.das.dds.api.IRouterDataSource;
import net.jplugin.core.das.dds.api.TablesplitException;
import net.jplugin.core.das.route.api.RouterDataSourceConfig;
import net.jplugin.core.das.route.api.SqlHandleService;
import net.jplugin.core.das.route.impl.autocreate.TableExistsMaintainer;
import net.jplugin.core.das.route.impl.conn.LogUtil;
import net.jplugin.core.das.route.impl.conn.SpecialReturnHandler;
import net.jplugin.core.das.route.impl.conn.SqlHandleResult;
import net.jplugin.core.das.route.impl.conn.mulqry.CombineStatementFactory;

public class RouterDataSource
extends AbstractRouterDataSource {
    PrintWriter logWriter;
    RouterDataSourceConfig config = new RouterDataSourceConfig();
    private String dataSourceName;

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public RouterDataSourceConfig getConfig() {
        return this.config;
    }

    @Override
    public void init(String routerDataSourceName, Map<String, String> c) {
        this.dataSourceName = routerDataSourceName;
        this.config.fromProperties(c);
    }

    @Override
    public Connection getTargetConnBefConnect() {
        return null;
    }

    @Override
    public PreparedStatement getTargetPreparedStmtBefCreate(IRouterDataSource routeDatasource, String sql) {
        if (this.checkSqlMatched(sql)) {
            return null;
        }
        return this.createDefaultPreparedStatement(sql);
    }

    @Override
    public PreparedStatement getTargetPreparedStmtBefExecute(IRouterDataSource routeDatasource, String sql, List<Object> params) throws SQLException {
        if (sql == null) {
            throw new TablesplitException("No sql found");
        }
        return this.computePreparedStatementResult(routeDatasource, sql, params);
    }

    @Override
    public IRouterDataSource.StatementResult getTargetStmtBefExecute(IRouterDataSource routeDatasource, String sql) throws SQLException {
        if (sql == null) {
            throw new TablesplitException("No sql found");
        }
        if (this.checkSqlMatched(sql)) {
            return this.computeStatementResult(routeDatasource, sql);
        }
        return this.createDefaultStatementResult(sql);
    }

    private IRouterDataSource.StatementResult createDefaultStatementResult(String sql) {
        return null;
    }

    private boolean checkSqlMatched(String sql) {
        return true;
    }

    private PreparedStatement createDefaultPreparedStatement(String sql) {
        return null;
    }

    private PreparedStatement computePreparedStatementResult(IRouterDataSource routeDatasource, String sql, List<Object> params) throws SQLException {
        PreparedStatement stmt;
        SqlHandleResult shr = SqlHandleService.INSTANCE.handle((RouterDataSource)routeDatasource, sql, params);
        LogUtil.instance.log(shr);
        String dsForMakeDymmy = shr.getDataSourceInfos()[0].getDsName();
        TableExistsMaintainer.MaintainReturn maintainResult = TableExistsMaintainer.maintainAndCheckNoneResult(shr);
        if (maintainResult.isSpecialCondition()) {
            PreparedStatement temp = SpecialReturnHandler.hanleSpecialConditionForPreparedStmt(maintainResult, DataSourceFactory.getDataSource(dsForMakeDymmy).getConnection());
            return temp;
        }
        if (!shr.singleTable()) {
            stmt = CombineStatementFactory.createPrepared(shr.getEncodedSql());
        } else {
            String dsname = shr.getDataSourceInfos()[0].getDsName();
            DataSource tds = DataSourceFactory.getDataSource(dsname);
            if (tds == null) {
                throw new TablesplitException("Can't find target datasource." + dsname);
            }
            stmt = tds.getConnection().prepareStatement(shr.getResultSql());
        }
        return stmt;
    }

    private IRouterDataSource.StatementResult computeStatementResult(IRouterDataSource routeDatasource, String sql) throws SQLException {
        Statement stmt;
        SqlHandleResult shr = SqlHandleService.INSTANCE.handle((RouterDataSource)routeDatasource, sql);
        LogUtil.instance.log(shr);
        String dsForMakeDymmy = shr.getDataSourceInfos()[0].getDsName();
        TableExistsMaintainer.MaintainReturn maintainResult = TableExistsMaintainer.maintainAndCheckNoneResult(shr);
        if (maintainResult.isSpecialCondition()) {
            IRouterDataSource.StatementResult temp = SpecialReturnHandler.hanleSpecialConditionForStatement(maintainResult, DataSourceFactory.getDataSource(dsForMakeDymmy).getConnection());
            return temp;
        }
        if (!shr.singleTable()) {
            stmt = CombineStatementFactory.create();
        } else {
            String dsname = shr.getDataSourceInfos()[0].getDsName();
            DataSource tds = DataSourceFactory.getDataSource(dsname);
            if (tds == null) {
                throw new TablesplitException("Can't find target datasource." + dsname);
            }
            stmt = tds.getConnection().createStatement();
        }
        IRouterDataSource.StatementResult result = new IRouterDataSource.StatementResult();
        result.setStatement(stmt);
        if (shr.singleTable()) {
            result.setResultSql(shr.getResultSql());
        } else {
            result.setResultSql(shr.getEncodedSql());
        }
        return result;
    }

    @Override
    public PreparedStatement getTargetPreparedStmtBefCreate(IRouterDataSource routeDatasource, String sql, int autoGenKeys) throws SQLException {
        throw new SQLException("NOT SUPPORT");
    }
}

