/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.mybatis.impl.sess;

import java.util.Hashtable;
import net.jplugin.core.das.mybatis.api.MyBatisServiceFactory;
import net.jplugin.core.das.mybatis.impl.MybaticsServiceImplNew;
import net.jplugin.core.das.mybatis.impl.sess.SessionClearContextListener;
import net.jplugin.core.das.mybatis.impl.sess.SqlSessionAdaptor;
import net.jplugin.core.kernel.api.ctx.ThreadLocalContext;
import net.jplugin.core.kernel.api.ctx.ThreadLocalContextListener;
import net.jplugin.core.kernel.api.ctx.ThreadLocalContextManager;
import org.apache.ibatis.session.SqlSession;

public class MybatisSessionManager {
    private static final String MYBATIS_SESSIONS = "MYBATIS_SESSIONS";
    private static ThreadLocalContextListener sessionClearCtxListener = new SessionClearContextListener();

    public static SqlSession getSession(String dataSourceName) {
        Hashtable<String, SqlSessionAdaptor> sessions = MybatisSessionManager.getSessions();
        SqlSessionAdaptor sess = sessions.get(dataSourceName);
        if (sess == null) {
            MybaticsServiceImplNew service = (MybaticsServiceImplNew)MyBatisServiceFactory.getService(dataSourceName);
            SqlSession sessInner = service._openRealSession();
            sess = new SqlSessionAdaptor(sessInner);
            ThreadLocalContextManager.instance.getContext().addContextListenerOnce(sessionClearCtxListener);
            sessions.put(dataSourceName, sess);
        }
        return sess;
    }

    private static Hashtable<String, SqlSessionAdaptor> getSessions() {
        Hashtable sessions = (Hashtable)ThreadLocalContextManager.instance.getContext().getAttribute(MYBATIS_SESSIONS);
        if (sessions == null) {
            sessions = new Hashtable();
            ThreadLocalContextManager.instance.getContext().setAttribute(MYBATIS_SESSIONS, sessions);
        }
        return sessions;
    }

    public static void clearSessions() {
        Hashtable<String, SqlSessionAdaptor> sessions = MybatisSessionManager.getSessions();
        for (SqlSessionAdaptor s : sessions.values()) {
            s.getRealSession().clearCache();
        }
    }

    public static void releaseSessions() {
        Hashtable<String, SqlSessionAdaptor> sessions = MybatisSessionManager.getSessions();
        if (sessions != null) {
            for (SqlSessionAdaptor s : sessions.values()) {
                s.getRealSession().close();
            }
            sessions.clear();
        }
    }

    public static void releaseSessions(ThreadLocalContext rc) {
        Hashtable sessions = (Hashtable)rc.getAttribute(MYBATIS_SESSIONS);
        if (sessions != null) {
            for (SqlSessionAdaptor s : sessions.values()) {
                s.getRealSession().close();
            }
            sessions.clear();
        }
    }
}

