/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.mybatis.impl;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import net.jplugin.common.kits.StringKit;
import net.jplugin.core.config.api.ConfigFactory;
import net.jplugin.core.das.api.DataSourceFactory;
import net.jplugin.core.das.mybatis.api.IMapperHandlerForReturn;
import net.jplugin.core.das.mybatis.impl.IMapperHandler;
import net.jplugin.core.das.mybatis.impl.IMybatisService;
import net.jplugin.core.das.mybatis.impl.sess.MybatisSessionManager;
import net.jplugin.core.kernel.api.PluginEnvirement;
import org.apache.ibatis.builder.xml.XMLConfigBuilder;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.LocalCacheScope;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.managed.ManagedTransactionFactory;

public class MybaticsServiceImplNew
implements IMybatisService {
    DataSource dataSource = null;
    SqlSessionFactory sqlSessionFactory;
    String theDataSourceName;
    private List<String> theMappers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String dataSourceName, List<String> mappers, List<Class> interceptors) {
        Configuration configuration;
        this.theDataSourceName = dataSourceName;
        this.theMappers = mappers;
        if (mappers == null || mappers.size() == 0) {
            PluginEnvirement.INSTANCE.getStartLogger().log("  No mappers configed.");
            return;
        }
        this.dataSource = DataSourceFactory.getDataSource(dataSourceName);
        Properties prop = new Properties();
        prop.setProperty("closeConnection", "false");
        ManagedTransactionFactory tm = new ManagedTransactionFactory();
        tm.setProperties(prop);
        Environment environment = new Environment("mybatis", (TransactionFactory)tm, this.dataSource);
        String globalConfigResource = this.checkGlocalConfigMapper(dataSourceName, mappers, interceptors);
        if (globalConfigResource != null) {
            configuration = this.buildGlobalConfiguration(globalConfigResource);
            configuration.setLocalCacheScope(LocalCacheScope.STATEMENT);
            if (configuration.getEnvironment() != null) {
                throw new RuntimeException("The global config for Mybatis MUST NOT has enviremonent element: " + globalConfigResource);
            }
            configuration.setEnvironment(environment);
        } else {
            configuration = new Configuration(environment);
            configuration.setLocalCacheScope(LocalCacheScope.STATEMENT);
            this.setMybatisPropertys(configuration);
            for (String c : mappers) {
                try {
                    if (c.endsWith(".xml") || c.endsWith(".XML")) {
                        InputStream inputStream = Resources.getResourceAsStream((String)c);
                        XMLMapperBuilder mapperParser = new XMLMapperBuilder(inputStream, configuration, c, configuration.getSqlFragments());
                        mapperParser.parse();
                        continue;
                    }
                    String tryFile = StringKit.replaceStr(c, ".", "/") + ".xml";
                    boolean exists = false;
                    InputStream stream = null;
                    try {
                        stream = this.getClass().getClassLoader().getResourceAsStream(tryFile);
                        if (stream != null) {
                            exists = true;
                        }
                    }
                    finally {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    if (!exists) {
                        configuration.addMapper(Class.forName(c));
                        continue;
                    }
                    c = tryFile;
                    InputStream inputStream = Resources.getResourceAsStream((String)c);
                    XMLMapperBuilder mapperParser = new XMLMapperBuilder(inputStream, configuration, c, configuration.getSqlFragments());
                    mapperParser.parse();
                }
                catch (Exception e) {
                    throw new RuntimeException("Error class:" + c, e);
                }
            }
            if (interceptors != null) {
                for (Class clazz : interceptors) {
                    Interceptor incept;
                    try {
                        incept = (Interceptor)clazz.newInstance();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new RuntimeException("create the mybatis interceptor error: " + clazz.getName());
                    }
                    configuration.addInterceptor(incept);
                }
            }
        }
        this.sqlSessionFactory = new SqlSessionFactoryBuilder().build(configuration);
    }

    private void setMybatisPropertys(Configuration configuration) {
        List methods = Arrays.stream(Configuration.class.getMethods()).filter(method -> method.getName().startsWith("set")).collect(Collectors.toList());
        Map<String, String> configMap = ConfigFactory.getStringConfigInGroup("mybatis_config");
        if (null != configMap && !configMap.isEmpty()) {
            block2: for (Map.Entry<String, String> entry : configMap.entrySet()) {
                String key = entry.getKey();
                for (Method method2 : methods) {
                    if (!method2.getName().toLowerCase().equals("set" + key.toLowerCase())) continue;
                    Class<?> parameterType = method2.getParameterTypes()[0];
                    Object value = this.castType(parameterType, entry.getValue());
                    try {
                        method2.invoke((Object)configuration, value);
                        continue block2;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("set mybatis property failed\uff0cname\uff1a" + key + "\uff0cvalue\uff1a" + value);
                    }
                }
            }
        }
    }

    private Object castType(Class<?> clazz, String value) {
        if (clazz.isEnum()) {
            try {
                return clazz.getMethod("valueOf", String.class).invoke(null, value);
            }
            catch (Exception e) {
                throw new RuntimeException("set enum property failed\uff0cname\uff1a" + clazz.getSimpleName() + "\uff0cvalue\uff1a" + value);
            }
        }
        switch (clazz.getSimpleName()) {
            case "Integer": 
            case "int": {
                return Integer.valueOf(value);
            }
            case "Short": 
            case "short": {
                return Short.valueOf(value);
            }
            case "Boolean": 
            case "boolean": {
                return Boolean.valueOf(value);
            }
            case "Byte": 
            case "byte": {
                return Byte.valueOf(value);
            }
            case "Long": 
            case "long": {
                return Long.valueOf(value);
            }
            case "Float": 
            case "float": {
                return Float.valueOf(value);
            }
            case "Double": 
            case "double": {
                return Double.valueOf(value);
            }
            case "String": {
                return value;
            }
        }
        throw new RuntimeException("illegal type: " + clazz.getSimpleName());
    }

    private Configuration buildGlobalConfiguration(String globalConfigResource) {
        InputStream inputStream = null;
        try {
            inputStream = Resources.getResourceAsStream((String)globalConfigResource);
            if (inputStream == null) {
                throw new RuntimeException("Can't find resource for:" + globalConfigResource);
            }
            Configuration configuration = new XMLConfigBuilder(inputStream).parse();
            return configuration;
        }
        catch (Exception e) {
            throw new RuntimeException("Rource error:" + globalConfigResource, e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String checkGlocalConfigMapper(String datasource, List<String> mappers, List<Class> interceptors) {
        if (mappers == null) {
            return null;
        }
        for (String m : mappers) {
            if (!m.startsWith("config://")) continue;
            if (mappers.size() != 1) {
                throw new RuntimeException("Mybatis config error: The global config [" + m + "] for datasource [" + datasource + "] MUST NOT exists with other mappers. total num:" + mappers.size());
            }
            if (interceptors != null && interceptors.size() > 0) {
                throw new RuntimeException("Mybatis config error: The global config [" + m + "] for datasource [" + datasource + "] MUST NOT exists with other Interceptors. total num:" + interceptors.size());
            }
            return m.substring("config://".length());
        }
        return null;
    }

    @Override
    public SqlSession openSession() {
        return MybatisSessionManager.getSession(this.theDataSourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void runWithMapper(Class<T> type, IMapperHandler<T> handler) {
        try (SqlSession sess = this.openSession();){
            Object mapper = this.sqlSessionFactory.getConfiguration().getMapper(type, sess);
            handler.run(mapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <M, R> R returnWithMapper(Class<M> type, IMapperHandlerForReturn<M, R> handler) {
        try (SqlSession sess = this.openSession();){
            Object mapper = this.sqlSessionFactory.getConfiguration().getMapper(type, sess);
            R r = handler.fetchResult(mapper);
            return r;
        }
    }

    @Override
    public Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T getMapper(Class<T> t) {
        return (T)this.openSession().getMapper(t);
    }

    public SqlSession _openRealSession() {
        return this.sqlSessionFactory.openSession();
    }

    @Override
    public boolean containsMapper(String clazz) {
        return this.theMappers.contains(clazz);
    }
}

