/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.mybatis.api;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import net.jplugin.core.das.api.PageCond;
import net.jplugin.core.das.mybatis.api.CountSqlParser;
import net.jplugin.core.log.api.LogFactory;
import net.jplugin.core.log.api.Logger;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.apache.ibatis.session.Configuration;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public abstract class PageInterceptor
implements Interceptor {
    private static final Logger logger = LogFactory.getLogger(PageInterceptor.class);
    private static final ObjectFactory DEFAULT_OBJECT_FACTORY = new DefaultObjectFactory();
    private static final ObjectWrapperFactory DEFAULT_OBJECT_WRAPPER_FACTORY = new DefaultObjectWrapperFactory();
    private static final ReflectorFactory DEFAULT_REFLECTOR_FACTORY = new DefaultReflectorFactory();
    private static final String defaultDialect = "mysql";
    private static final String defaultPageSqlId = ".*Page$";

    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement mappedStatement;
        String pageSqlId;
        Object object;
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        MetaObject metaStatementHandler = MetaObject.forObject((Object)statementHandler, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)DEFAULT_REFLECTOR_FACTORY);
        while (metaStatementHandler.hasGetter("h")) {
            object = metaStatementHandler.getValue("h");
            metaStatementHandler = MetaObject.forObject((Object)object, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)DEFAULT_REFLECTOR_FACTORY);
        }
        while (metaStatementHandler.hasGetter("target")) {
            object = metaStatementHandler.getValue("target");
            metaStatementHandler = MetaObject.forObject((Object)object, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)DEFAULT_REFLECTOR_FACTORY);
        }
        Configuration configuration = (Configuration)metaStatementHandler.getValue("delegate.configuration");
        String dialect = configuration.getVariables().getProperty("dialect");
        if (null == dialect || "".equals(dialect)) {
            dialect = defaultDialect;
        }
        if (null == (pageSqlId = configuration.getVariables().getProperty("pageSqlId")) || "".equals(pageSqlId)) {
            pageSqlId = defaultPageSqlId;
        }
        if ((mappedStatement = (MappedStatement)metaStatementHandler.getValue("delegate.mappedStatement")).getId().matches(pageSqlId)) {
            BoundSql boundSql = (BoundSql)metaStatementHandler.getValue("delegate.boundSql");
            Object parameterObject = boundSql.getParameterObject();
            if (parameterObject == null) {
                throw new NullPointerException("parameterObject is null!");
            }
            PageCond page = (PageCond)metaStatementHandler.getValue("delegate.boundSql.parameterObject.page");
            String sql = boundSql.getSql();
            String pageSql = this.buildPageSql(sql, page);
            metaStatementHandler.setValue("delegate.boundSql.sql", (Object)pageSql);
            metaStatementHandler.setValue("delegate.rowBounds.offset", (Object)0);
            metaStatementHandler.setValue("delegate.rowBounds.limit", (Object)Integer.MAX_VALUE);
            Connection connection = (Connection)invocation.getArgs()[0];
            if (page.isShdCount()) {
                this.setPageParameter(sql, connection, mappedStatement, boundSql, page);
            }
        }
        return invocation.proceed();
    }

    private void setPageParameter(String sql, Connection connection, MappedStatement mappedStatement, BoundSql boundSql, PageCond page) throws SQLException {
        String countSql = CountSqlParser.getSmartCountSql(sql);
        PreparedStatement countStmt = null;
        ResultSet rs = null;
        try {
            countStmt = connection.prepareStatement(countSql);
            BoundSql countBS = new BoundSql(mappedStatement.getConfiguration(), countSql, boundSql.getParameterMappings(), boundSql.getParameterObject());
            this.setParameters(countStmt, mappedStatement, countBS, boundSql.getParameterObject());
            rs = countStmt.executeQuery();
            int totalCount = 0;
            if (rs.next()) {
                totalCount = rs.getInt(1);
            }
            page.setCount(totalCount);
        }
        catch (SQLException e) {
            logger.error((Object)"Ignore this exception", e);
            throw e;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)"Ignore this exception", e);
            }
            try {
                if (countStmt != null) {
                    countStmt.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)"Ignore this exception", e);
            }
        }
    }

    private void setParameters(PreparedStatement ps, MappedStatement mappedStatement, BoundSql boundSql, Object parameterObject) throws SQLException {
        DefaultParameterHandler parameterHandler = new DefaultParameterHandler(mappedStatement, parameterObject, boundSql);
        parameterHandler.setParameters(ps);
    }

    protected abstract String buildPageSql(String var1, PageCond var2);

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }
}

