/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.mybatis.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.ValuesList;
import net.sf.jsqlparser.statement.select.WithItem;

public class CountSqlParser {
    public static final String KEEP_ORDERBY = "/*keep orderby*/";
    private static final Alias TABLE_ALIAS = new Alias("table_count", false);
    private static final Set<String> AGGREGATE_FUNCTIONS = new HashSet<String>(Arrays.asList("APPROX_COUNT_DISTINCT,ARRAY_AGG,AVG,BIT_,BOOL_,CHECKSUM_AGG,COLLECT,CORR,COUNT,COVAR,CUME_DIST,DENSE_RANK,EVERY,FIRST,GROUP,JSON_,LAST,LISTAGG,MAX,MEDIAN,MIN,PERCENT_,RANK,REGR_,SELECTIVITY,STATS_,STD,STRING_AGG,SUM,SYS_OP_ZONE_ID,SYS_XMLAGG,VAR,XMLAGG".split(",")));

    public static void addAggregateFunctions(String functions) {
        if (null != functions && !"".equals(functions.trim())) {
            String[] funs;
            for (String fun : funs = functions.split(",")) {
                AGGREGATE_FUNCTIONS.add(fun.toUpperCase());
            }
        }
    }

    public static String getSmartCountSql(String sql) {
        return CountSqlParser.getSmartCountSql(sql, "0");
    }

    public static String getSmartCountSql(String sql, String name) {
        Statement stmt = null;
        if (sql.contains(KEEP_ORDERBY)) {
            return CountSqlParser.getSimpleCountSql(sql, name);
        }
        try {
            stmt = CCJSqlParserUtil.parse((String)sql);
        }
        catch (Throwable e) {
            return CountSqlParser.getSimpleCountSql(sql, name);
        }
        Select select = (Select)stmt;
        SelectBody selectBody = select.getSelectBody();
        try {
            CountSqlParser.processSelectBody(selectBody);
        }
        catch (Exception e) {
            return CountSqlParser.getSimpleCountSql(sql, name);
        }
        CountSqlParser.processWithItemsList(select.getWithItemsList());
        CountSqlParser.sqlToCount(select, name);
        return select.toString();
    }

    public static String getSimpleCountSql(String sql) {
        return CountSqlParser.getSimpleCountSql(sql, "0");
    }

    public static String getSimpleCountSql(String sql, String name) {
        StringBuilder stringBuilder = new StringBuilder(sql.length() + 40);
        stringBuilder.append("select count(");
        stringBuilder.append(name);
        stringBuilder.append(") from (");
        stringBuilder.append(sql);
        stringBuilder.append(") tmp_count");
        return stringBuilder.toString();
    }

    public static void sqlToCount(Select select, String name) {
        SelectBody selectBody = select.getSelectBody();
        ArrayList<SelectExpressionItem> COUNT_ITEM = new ArrayList<SelectExpressionItem>();
        COUNT_ITEM.add(new SelectExpressionItem((Expression)new Column("count(" + name + ")")));
        if (selectBody instanceof PlainSelect && CountSqlParser.isSimpleCount((PlainSelect)selectBody)) {
            ((PlainSelect)selectBody).setSelectItems(COUNT_ITEM);
        } else {
            PlainSelect plainSelect = new PlainSelect();
            SubSelect subSelect = new SubSelect();
            subSelect.setSelectBody(selectBody);
            subSelect.setAlias(TABLE_ALIAS);
            plainSelect.setFromItem((FromItem)subSelect);
            plainSelect.setSelectItems(COUNT_ITEM);
            select.setSelectBody((SelectBody)plainSelect);
        }
    }

    public static boolean isSimpleCount(PlainSelect select) {
        if (select.getGroupBy() != null) {
            return false;
        }
        if (select.getDistinct() != null) {
            return false;
        }
        HashSet<String> skipFunctions = new HashSet<String>();
        for (SelectItem item : select.getSelectItems()) {
            String NAME;
            String name;
            Expression expression;
            if (item.toString().contains("?")) {
                return false;
            }
            if (!(item instanceof SelectExpressionItem) || !((expression = ((SelectExpressionItem)item).getExpression()) instanceof Function) || (name = ((Function)expression).getName()) == null || skipFunctions.contains(NAME = name.toUpperCase())) continue;
            for (String aggregateFunction : AGGREGATE_FUNCTIONS) {
                if (!NAME.startsWith(aggregateFunction)) continue;
                return false;
            }
            skipFunctions.add(NAME);
        }
        return true;
    }

    public static void processSelectBody(SelectBody selectBody) {
        if (selectBody instanceof PlainSelect) {
            CountSqlParser.processPlainSelect((PlainSelect)selectBody);
        } else if (selectBody instanceof WithItem) {
            WithItem withItem = (WithItem)selectBody;
            if (withItem.getSelectBody() != null) {
                CountSqlParser.processSelectBody(withItem.getSelectBody());
            }
        } else {
            SetOperationList operationList = (SetOperationList)selectBody;
            if (operationList.getSelects() != null && operationList.getSelects().size() > 0) {
                List plainSelects = operationList.getSelects();
                for (SelectBody plainSelect : plainSelects) {
                    CountSqlParser.processSelectBody(plainSelect);
                }
            }
            if (!CountSqlParser.orderByHashParameters(operationList.getOrderByElements())) {
                operationList.setOrderByElements(null);
            }
        }
    }

    public static void processPlainSelect(PlainSelect plainSelect) {
        if (!CountSqlParser.orderByHashParameters(plainSelect.getOrderByElements())) {
            plainSelect.setOrderByElements(null);
        }
        if (plainSelect.getFromItem() != null) {
            CountSqlParser.processFromItem(plainSelect.getFromItem());
        }
        if (plainSelect.getJoins() != null && plainSelect.getJoins().size() > 0) {
            List joins = plainSelect.getJoins();
            for (Join join : joins) {
                if (join.getRightItem() == null) continue;
                CountSqlParser.processFromItem(join.getRightItem());
            }
        }
    }

    public static void processWithItemsList(List<WithItem> withItemsList) {
        if (withItemsList != null && withItemsList.size() > 0) {
            for (WithItem item : withItemsList) {
                CountSqlParser.processSelectBody(item.getSelectBody());
            }
        }
    }

    public static void processFromItem(FromItem fromItem) {
        SubSelect subSelect;
        LateralSubSelect lateralSubSelect;
        if (fromItem instanceof SubJoin) {
            SubJoin subJoin = (SubJoin)fromItem;
            if (subJoin.getJoinList() != null && subJoin.getJoinList().size() > 0) {
                for (Join join : subJoin.getJoinList()) {
                    if (join.getRightItem() == null) continue;
                    CountSqlParser.processFromItem(join.getRightItem());
                }
            }
            if (subJoin.getLeft() != null) {
                CountSqlParser.processFromItem(subJoin.getLeft());
            }
        } else if (fromItem instanceof SubSelect) {
            SubSelect subSelect2 = (SubSelect)fromItem;
            if (subSelect2.getSelectBody() != null) {
                CountSqlParser.processSelectBody(subSelect2.getSelectBody());
            }
        } else if (!(fromItem instanceof ValuesList) && fromItem instanceof LateralSubSelect && (lateralSubSelect = (LateralSubSelect)fromItem).getSubSelect() != null && (subSelect = lateralSubSelect.getSubSelect()).getSelectBody() != null) {
            CountSqlParser.processSelectBody(subSelect.getSelectBody());
        }
    }

    public static boolean orderByHashParameters(List<OrderByElement> orderByElements) {
        if (orderByElements == null) {
            return false;
        }
        for (OrderByElement orderByElement : orderByElements) {
            if (!orderByElement.toString().contains("?")) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        String sql = "select id, name from t_bdqe_user order by age desc";
        String smartCountSql = CountSqlParser.getSmartCountSql(sql);
        System.out.println(smartCountSql);
    }
}

