/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.monitor;

import net.jplugin.core.das.api.monitor.ISqlMonitorListener;
import net.jplugin.core.das.api.monitor.ResultSetContext;
import net.jplugin.core.das.api.monitor.StatementContext;
import net.jplugin.core.kernel.api.PluginEnvirement;

public class SqlMonitorListenerManager {
    public static SqlMonitorListenerManager instance = new SqlMonitorListenerManager();
    ISqlMonitorListener[] arr;

    public void init() {
        ISqlMonitorListener[] a = PluginEnvirement.getInstance().getExtensionObjects("EP_SQL_LISTENER", ISqlMonitorListener.class);
        if (a != null && a.length > 0) {
            this.arr = a;
            PluginEnvirement.getInstance().getStartLogger().log("Sql Monitor listener size:" + this.arr.length);
        }
    }

    public boolean hasListener() {
        return this.arr != null && this.arr.length > 0;
    }

    public void beforeExecute(StatementContext ctx) {
        for (ISqlMonitorListener o : this.arr) {
            if (o.beforeExecute(ctx)) continue;
            throw new RuntimeException("The sql is prevent by sql filter. sql:" + ctx.getSql() + " listener:" + o.getClass());
        }
    }

    public void beforeNext(ResultSetContext ctx) {
        for (ISqlMonitorListener o : this.arr) {
            if (o.beforeNext(ctx)) continue;
            throw new RuntimeException("The cursor fetch is prevent by sql filter. sql:" + ctx.getSql() + " listener:" + o.getClass());
        }
    }

    public void afterExecute(StatementContext ctx) {
        for (int i = this.arr.length - 1; i >= 0; --i) {
            this.arr[i].afterExecute(ctx);
        }
    }

    public void afterNext(ResultSetContext ctx) {
        for (int i = this.arr.length - 1; i >= 0; --i) {
            this.arr[i].afterNext(ctx);
        }
    }
}

