/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.monitor;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.jplugin.common.kits.tuple.Tuple2;
import net.jplugin.core.das.api.monitor.ResultSetContext;
import net.jplugin.core.das.api.monitor.SqlMonitorListenerContext;
import net.jplugin.core.das.api.monitor.StatementContext;
import net.jplugin.core.das.monitor.ConnectionWrapper;
import net.jplugin.core.das.monitor.ResultSetWrapper;
import net.jplugin.core.das.monitor.SqlCall;
import net.jplugin.core.das.monitor.SqlMonitorListenerManager;
import net.jplugin.core.das.monitor.StatemenWrapper;
import net.jplugin.core.kernel.api.PluginFilterManager;

public class SqlMonitor {
    static PluginFilterManager<Tuple2<StatementContext, SqlCall>> execFilter = new PluginFilterManager<Tuple2>("EP_SQL_EXEC_FILTER", (fc, ctx) -> ((SqlCall)ctx.second).call());
    static boolean hasFilter;

    public static void initExecFilter() {
        execFilter.init();
        hasFilter = execFilter.chainSize() > 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object execute(StatemenWrapper stmt, String methodName, SqlCall sc) throws SQLException {
        StatementContext ctx = stmt.getCtx();
        SqlMonitorListenerManager.instance.beforeExecute(ctx);
        try {
            Object ret = execFilter.filter(Tuple2.with(ctx, sc));
            if (ret instanceof ResultSet) {
                ResultSetWrapper resultSetWrapper = new ResultSetWrapper(stmt.getDataSourceName(), (ResultSet)ret, stmt.getTheSql());
                return resultSetWrapper;
            }
            Object object = ret;
            return object;
        }
        catch (Exception e) {
            Object object = SqlMonitor.setAndRethrow(ctx, e);
            return object;
        }
        finally {
            SqlMonitorListenerManager.instance.afterExecute(ctx);
        }
    }

    public static Object createStatement(ConnectionWrapper conn, SqlCall sc) throws SQLException {
        Object ret = sc.call();
        return new StatemenWrapper(conn.getDataSourceName(), (Statement)ret, null);
    }

    public static Object prepareStatement(ConnectionWrapper conn, String sql, SqlCall sc) throws SQLException {
        Object ret = sc.call();
        return new StatemenWrapper(conn.getDataSourceName(), (Statement)ret, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object next(ResultSetWrapper rs, SqlCall sc) throws SQLException {
        ResultSetContext ctx = rs.getCtx();
        SqlMonitorListenerManager.instance.beforeNext(ctx);
        try {
            Object object = sc.call();
            return object;
        }
        catch (Exception e) {
            Object object = SqlMonitor.setAndRethrow(ctx, e);
            return object;
        }
        finally {
            SqlMonitorListenerManager.instance.afterNext(ctx);
        }
    }

    private static Object setAndRethrow(SqlMonitorListenerContext c, Exception e) throws SQLException {
        c.setException(e);
        if (e instanceof SQLException) {
            throw (SQLException)e;
        }
        if (e.getCause() != null && e.getCause() instanceof SQLException) {
            throw (SQLException)e.getCause();
        }
        throw new SQLException(e);
    }

    public static ResultSet getResultSet(StatemenWrapper stmt, SqlCall sc) throws SQLException {
        ResultSet ret = (ResultSet)sc.call();
        if (ret == null) {
            return null;
        }
        return new ResultSetWrapper(stmt.getDataSourceName(), ret, stmt.getTheSql());
    }
}

