/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.kits;

import java.util.List;
import net.jplugin.core.das.kits.SqlStrLexerToolNew;

public class SqlWordsWalker {
    String[] words;
    public int position;
    public String word;
    public String sql;

    public static SqlWordsWalker createFromSql(String sql) {
        List<String> words = new SqlStrLexerToolNew(sql).parse();
        String[] arr = new String[words.size()];
        SqlWordsWalker sw = new SqlWordsWalker(words.toArray(arr));
        sw.sql = sql;
        return sw;
    }

    SqlWordsWalker(String[] w) {
        this.words = w;
        this.reset();
    }

    public String[] getArray() {
        return this.words;
    }

    public int positionFrom(int start, String s) {
        for (int i = start; i < this.words.length; ++i) {
            if (!s.equals(this.words[i])) continue;
            return i;
        }
        return -1;
    }

    public String wordAt(int i) {
        return this.words[i];
    }

    public int size() {
        return this.words.length;
    }

    public void reset() {
        this.position = -1;
        this.word = null;
    }

    public boolean next() {
        if (this.position >= this.words.length - 1) {
            return false;
        }
        this.word = this.words[++this.position];
        return true;
    }

    public boolean next(int n) {
        if (this.position >= this.words.length - n) {
            return false;
        }
        this.word = this.words[this.position += n];
        return true;
    }

    public void setPosition(int pos) {
        if (pos >= -1 && pos <= this.words.length - 1) {
            this.position = pos;
            this.word = pos != -1 ? this.words[pos] : null;
        }
    }

    public int getPosition() {
        return this.position;
    }

    public boolean nextUntilIgnoreCase(String s) {
        while (this.next()) {
            if (!s.equalsIgnoreCase(this.word)) continue;
            return true;
        }
        return false;
    }

    public boolean nextUntil(String s) {
        while (this.next()) {
            if (!s.equals(this.word)) continue;
            return true;
        }
        return false;
    }

    public String getNextWord(int n) {
        if (this.position >= this.words.length - n) {
            return null;
        }
        return this.words[this.position + n];
    }

    public String getNextWord() {
        if (this.position >= this.words.length - 1) {
            return null;
        }
        return this.words[this.position + 1];
    }

    public void nextUntilMatchingBracket() {
        int leftBracketNum = 1;
        while (this.next()) {
            if ("(".equals(this.word)) {
                ++leftBracketNum;
            }
            if (!")".equals(this.word) || --leftBracketNum != 0) continue;
            break;
        }
    }

    public String toSql() {
        return SqlWordsWalker.appendToBuffer(new StringBuffer(), this.words);
    }

    public static String appendToBuffer(StringBuffer sb, String[] list) {
        boolean first = true;
        for (String s : list) {
            if (first) {
                sb.append(s);
                first = false;
                continue;
            }
            if (s.equals("(")) {
                sb.append(s);
                continue;
            }
            sb.append(" ").append(s);
        }
        return sb.toString();
    }
}

