/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.kits;

import java.util.ArrayList;
import java.util.List;
import net.jplugin.core.das.dds.api.TablesplitException;

public class SqlStrLexerToolNew {
    public static final int STATE_STR_CONST = 1;
    public static final int STATE_WORD = 2;
    public static final int STATE_SPACING = 3;
    public static final int STATE_OPERATOR = 4;
    char[] buffer;
    int idx = 0;
    List<String> list = new ArrayList<String>();
    private static boolean debug;

    public SqlStrLexerToolNew(String sql) {
        this.buffer = sql.toCharArray();
    }

    public List<String> parse() {
        while (true) {
            if (this.idx < this.buffer.length && this.isWhiteSpace(this.buffer[this.idx])) {
                ++this.idx;
                continue;
            }
            if (this.idx >= this.buffer.length) break;
            char c = this.buffer[this.idx];
            if (this.isWordCharStart()) {
                this.parseWord();
            } else if (this.isCommentStart()) {
                this.parseComment();
            } else if (this.isOperatorStart()) {
                this.parseOperator();
            } else if (this.isConstStart()) {
                this.parseConst();
            } else if (this.isFanPieStart()) {
                this.parseFanPie();
            } else if (this.isSplit()) {
                this.parseSplit();
            } else {
                throw new TablesplitException("Error sql ,unexpacted char at [" + this.idx + "] '" + c + "'  SQL:=" + new String(this.buffer));
            }
            ++this.idx;
            if (!debug || this.list.size() <= 0) continue;
            System.out.println(this.list.get(this.list.size() - 1));
        }
        return this.list;
    }

    private boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\n' || c == '\r' || c == '\t';
    }

    private void parseFanPie() {
        int start = this.idx;
        while (++this.idx < this.buffer.length) {
            if (!this.isFanPieEnd()) continue;
            this.list.add(new String(this.buffer, start, this.idx - start + 1));
            return;
        }
        this.list.add(new String(this.buffer, start, this.buffer.length - this.idx));
    }

    public boolean isFanPieEnd() {
        return this.buffer[this.idx] == '`';
    }

    private boolean isFanPieStart() {
        return this.buffer[this.idx] == '`';
    }

    private boolean isWordCharStart() {
        char c = this.buffer[this.idx];
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || c == '.';
    }

    private boolean isWordCharEnd() {
        if (this.idx == this.buffer.length - 1) {
            return true;
        }
        char c = this.buffer[this.idx + 1];
        return !(c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || c == '.');
    }

    public boolean isOperatorStart() {
        char c = this.buffer[this.idx];
        return c == '=' || c == '<' || c == '>' || c == '&' || c == '^' || c == '+' || c == '-' || c == '*' || c == '/' || c == '!';
    }

    public boolean isConstStart() {
        return this.buffer[this.idx] == '\'';
    }

    public boolean isConstEnd() {
        return this.buffer[this.idx] == '\'' && this.buffer[this.idx - 1] != '\\';
    }

    public boolean isSplit() {
        char c = this.buffer[this.idx];
        return c == ',' || c == '(' || c == ')' || c == ']' || c == '[' || c == '{' || c == '}' || c == ';' || c == '?';
    }

    public boolean isCommentStart() {
        if (this.idx + 1 >= this.buffer.length) {
            return false;
        }
        return this.buffer[this.idx] == '/' && this.buffer[this.idx + 1] == '*';
    }

    public boolean isCommentEnd() {
        if (this.idx - 1 < 0) {
            return false;
        }
        return this.buffer[this.idx] == '/' && this.buffer[this.idx - 1] == '*';
    }

    public void parseWord() {
        int start = this.idx;
        while (this.idx < this.buffer.length) {
            if (this.isWordCharEnd()) {
                this.list.add(new String(this.buffer, start, this.idx - start + 1));
                return;
            }
            ++this.idx;
        }
        throw new RuntimeException("logic error.");
    }

    public void parseOperator() {
        if (this.idx + 1 >= this.buffer.length) {
            this.list.add(new String(this.buffer, this.idx, 1));
            return;
        }
        char c1 = this.buffer[this.idx];
        char c2 = this.buffer[this.idx + 1];
        if (c1 == '>' && c2 == '=' || c1 == '<' && c2 == '=' || c1 == '<' && c2 == '>' || c1 == '!' && c2 == '=') {
            this.list.add(new String(this.buffer, this.idx, 2));
            ++this.idx;
            return;
        }
        this.list.add(new String(this.buffer, this.idx, 1));
    }

    public void parseConst() {
        int start = this.idx;
        while (++this.idx < this.buffer.length) {
            if (!this.isConstEnd()) continue;
            this.list.add(new String(this.buffer, start, this.idx - start + 1));
            return;
        }
        this.list.add(new String(this.buffer, start, this.buffer.length - this.idx));
    }

    public void parseComment() {
        int start = this.idx;
        while (++this.idx < this.buffer.length) {
            if (!this.isCommentEnd()) continue;
            this.list.add(new String(this.buffer, start, this.idx - start + 1));
            return;
        }
        this.list.add(new String(this.buffer, start, this.buffer.length - this.idx));
    }

    public void parseSplit() {
        this.list.add(new String(this.buffer, this.idx, 1));
    }

    public static void main(String[] args) {
        debug = true;
        List<String> result = new SqlStrLexerToolNew("select  /*spantable  */  count(0) from tb_route0 SQL=select  /*spantable  */  count(0) from tb_route0").parse();
    }
}

