/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.dds.select;

import java.util.ArrayList;
import java.util.List;
import net.jplugin.common.kits.tuple.Tuple2;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Block;
import net.sf.jsqlparser.statement.Commit;
import net.sf.jsqlparser.statement.DescribeStatement;
import net.sf.jsqlparser.statement.ExplainStatement;
import net.sf.jsqlparser.statement.SetStatement;
import net.sf.jsqlparser.statement.ShowColumnsStatement;
import net.sf.jsqlparser.statement.ShowStatement;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.Statements;
import net.sf.jsqlparser.statement.UseStatement;
import net.sf.jsqlparser.statement.alter.Alter;
import net.sf.jsqlparser.statement.comment.Comment;
import net.sf.jsqlparser.statement.create.index.CreateIndex;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.view.AlterView;
import net.sf.jsqlparser.statement.create.view.CreateView;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.drop.Drop;
import net.sf.jsqlparser.statement.execute.Execute;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.merge.Merge;
import net.sf.jsqlparser.statement.replace.Replace;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.ParenthesisFromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.TableFunction;
import net.sf.jsqlparser.statement.select.ValuesList;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.truncate.Truncate;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.statement.upsert.Upsert;
import net.sf.jsqlparser.statement.values.ValuesStatement;

public class TableNameAndCommandFinder
implements StatementVisitor,
SelectVisitor,
FromItemVisitor {
    public static final String NOT_SUPPORT_YET = "not support yet";
    private List<String> tables = new ArrayList<String>();
    private String command;

    public static Tuple2<List<String>, String> find(Statement result) {
        TableNameAndCommandFinder finder = new TableNameAndCommandFinder();
        result.accept((StatementVisitor)finder);
        return Tuple2.with(finder.tables, finder.command);
    }

    private void addTable(Table tableName) {
        this.tables.add(tableName.getFullyQualifiedName());
    }

    private void setCommand(String cmd) {
        if (this.command != null) {
            throw new RuntimeException("cmd can't set twice");
        }
        this.command = cmd;
    }

    public void visit(Table tableName) {
        this.addTable(tableName);
    }

    public void visit(SubSelect subSelect) {
        subSelect.getSelectBody().accept((SelectVisitor)this);
    }

    public void visit(SubJoin subjoin) {
        subjoin.getLeft().accept((FromItemVisitor)this);
        for (Join join : subjoin.getJoinList()) {
            join.getRightItem().accept((FromItemVisitor)this);
        }
    }

    public void visit(LateralSubSelect lateralSubSelect) {
        lateralSubSelect.getSubSelect().getSelectBody().accept((SelectVisitor)this);
    }

    public void visit(ValuesList valuesList) {
    }

    public void visit(TableFunction tableFunction) {
    }

    public void visit(ParenthesisFromItem aThis) {
        aThis.getFromItem().accept((FromItemVisitor)this);
    }

    public void visit(PlainSelect plainSelect) {
        if (plainSelect.getFromItem() != null) {
            plainSelect.getFromItem().accept((FromItemVisitor)this);
        }
        if (plainSelect.getJoins() != null) {
            for (Join join : plainSelect.getJoins()) {
                join.getRightItem().accept((FromItemVisitor)this);
            }
        }
    }

    public void visit(SetOperationList list) {
        for (SelectBody plainSelect : list.getSelects()) {
            plainSelect.accept((SelectVisitor)this);
        }
    }

    public void visit(WithItem withItem) {
    }

    public void visit(ValuesStatement values) {
    }

    public void visit(Comment comment) {
        this.setCommand("COMMENT");
        if (comment.getTable() != null) {
            this.addTable(comment.getTable());
        }
    }

    public void visit(Commit commit) {
    }

    public void visit(Delete delete) {
        this.setCommand("DELETE");
        this.addTable(delete.getTable());
    }

    public void visit(Update update) {
        this.setCommand("UPDATE");
        for (Table table : update.getTables()) {
            this.addTable(table);
        }
    }

    public void visit(Insert insert) {
        this.setCommand("INSERT");
        this.addTable(insert.getTable());
    }

    public void visit(Replace replace) {
        this.setCommand("REPLACE");
        this.addTable(replace.getTable());
    }

    public void visit(Drop drop) {
        this.setCommand("DROP");
        this.addTable(drop.getName());
    }

    public void visit(Truncate truncate) {
        this.setCommand("TRUNCATE");
        this.addTable(truncate.getTable());
    }

    public void visit(CreateIndex createIndex) {
        this.setCommand("CREATE_INDEX");
        this.addTable(createIndex.getTable());
    }

    public void visit(CreateTable createTable) {
        this.setCommand("CREATE_TABLE");
        this.addTable(createTable.getTable());
    }

    public void visit(CreateView createView) {
        this.setCommand("CREATE_VIEW");
        this.addTable(createView.getView());
    }

    public void visit(AlterView alterView) {
        this.setCommand("ALTER_VIEW");
        this.addTable(alterView.getView());
    }

    public void visit(Alter alter) {
        this.setCommand("ALTER");
        this.addTable(alter.getTable());
    }

    public void visit(Statements stmts) {
        for (Statement st : stmts.getStatements()) {
            st.accept((StatementVisitor)this);
        }
    }

    public void visit(Execute execute) {
        throw new RuntimeException(NOT_SUPPORT_YET);
    }

    public void visit(SetStatement set) {
        throw new RuntimeException(NOT_SUPPORT_YET);
    }

    public void visit(ShowColumnsStatement set) {
        throw new RuntimeException(NOT_SUPPORT_YET);
    }

    public void visit(Merge merge) {
        this.setCommand("MERGE");
        this.addTable(merge.getTable());
    }

    public void visit(Select select) {
        this.setCommand("SELECT");
        select.getSelectBody().accept((SelectVisitor)this);
    }

    public void visit(Upsert upsert) {
        this.setCommand("UPSERT");
        this.addTable(upsert.getTable());
    }

    public void visit(UseStatement use) {
        throw new RuntimeException(NOT_SUPPORT_YET);
    }

    public void visit(Block block) {
        throw new RuntimeException(NOT_SUPPORT_YET);
    }

    public void visit(DescribeStatement describe) {
        this.setCommand("DESC");
        this.addTable(describe.getTable());
    }

    public void visit(ExplainStatement aThis) {
        throw new RuntimeException(NOT_SUPPORT_YET);
    }

    public void visit(ShowStatement aThis) {
        throw new RuntimeException(NOT_SUPPORT_YET);
    }
}

