/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.dds.select;

import java.util.ArrayList;
import java.util.Map;
import net.jplugin.common.kits.StringKit;
import net.jplugin.common.kits.StringMatcher;
import net.jplugin.common.kits.tuple.Tuple2;
import net.jplugin.core.das.dds.api.RouterException;

public class SelectDatasourceConfig {
    private static final String EMPTY = "_EMPTY_";
    public static final String PATH_LIST = "path-list";
    public static final String POST_COMMANDS = "commands";
    public static final String POST_TABLES = "tables";
    public static final String POST_TARGET = "target";
    public static final String POST_DEFAULT = "default";
    public static final String CMD_SELECT = "SELECT";
    public static final String CMD_UPDATE = "UPDATE";
    public static final String CMD_DELETE = "DELETE";
    public static final String CMD_INSERT = "INSERT";
    public static final String CMD_COMMENT = "COMMENT";
    public static final String CMD_REPLACE = "REPLACE";
    public static final String CMD_TRUNCATE = "TRUNCATE";
    public static final String CMD_DROP = "DROP";
    public static final String CMD_CREATE_INDEX = "CREATE_INDEX";
    public static final String CMD_CREATE_TABLE = "CREATE_TABLE";
    public static final String CMD_CREATE_VIEW = "CREATE_VIEW";
    public static final String CMD_ALTER_VIEW = "ALTER_VIEW";
    public static final String CMD_ALTER = "ALTER";
    public static final String CMD_MERGE = "MERGE";
    public static final String CMD_UPSERT = "UPSERT";
    public static final String CMD_DESC = "DESC";
    Path[] notDefaultPaths;
    Path defaultPath;

    public static SelectDatasourceConfig create(Map<String, String> c) {
        SelectDatasourceConfig o = new SelectDatasourceConfig();
        o.from(c);
        return o;
    }

    public String getTargetDataSource(String command, String schemaAndTableName) {
        if (this.notDefaultPaths != null) {
            for (Path p : this.notDefaultPaths) {
                if (!p.matchCommand(command) || !p.matchTable(schemaAndTableName)) continue;
                return p.target;
            }
        }
        if (this.defaultPath != null) {
            return this.defaultPath.target;
        }
        throw new RuntimeException("can't find target");
    }

    private void from(Map<String, String> config) {
        String list = config.get(PATH_LIST);
        if (StringKit.isNull(list)) {
            throw new RouterException("path-list can't be null configed.");
        }
        String[] pList = StringKit.splitStrAndTrim(list, ",");
        Path[] pathList = new Path[pList.length];
        if (pathList.length == 0) {
            throw new RuntimeException("no path configed for key:path-list");
        }
        for (int i = 0; i < pathList.length; ++i) {
            String prefix = pList[i] + "-";
            String commandsMatcher = config.get(prefix + POST_COMMANDS);
            String tablesMatcher = config.get(prefix + POST_TABLES);
            String isDefault = config.get(prefix + POST_DEFAULT);
            String target = config.get(prefix + POST_TARGET);
            if (commandsMatcher != null) {
                commandsMatcher = commandsMatcher.toUpperCase().trim();
            }
            if (tablesMatcher != null) {
                tablesMatcher = tablesMatcher.toUpperCase().trim();
            }
            if (isDefault != null) {
                isDefault = isDefault.toUpperCase().trim();
            }
            if (target == null) {
                throw new RuntimeException("target datasource can't be null");
            }
            target = target.trim();
            pathList[i] = new Path(commandsMatcher, tablesMatcher, isDefault, target);
        }
        ArrayList<Path> unDefault = new ArrayList<Path>();
        for (Path p : pathList) {
            if (p.isDefault) {
                if (this.defaultPath != null) {
                    throw new RuntimeException("only one default path is allowed");
                }
                this.defaultPath = p;
                continue;
            }
            unDefault.add(p);
        }
        this.notDefaultPaths = unDefault.toArray(new Path[unDefault.size()]);
    }

    public static class Path {
        StringMatcher commandsMatcher;
        TableMatcher tablesMatcher;
        boolean isDefault;
        String target;

        public Path(String upperCm, String upperTm, String upperIsDefault, String tgt) {
            this.commandsMatcher = new StringMatcher(upperCm);
            Tuple2<String, String> tup = this.getSchemaAndName(upperTm);
            this.tablesMatcher = new TableMatcher();
            this.tablesMatcher.schemaMatcher = new StringMatcher((String)tup.first);
            this.tablesMatcher.tableMatcher = new StringMatcher((String)tup.second);
            this.isDefault = "TRUE".equalsIgnoreCase(upperIsDefault);
            this.target = tgt;
        }

        public boolean matchCommand(String command) {
            command = StringKit.trim(command).toUpperCase();
            return this.commandsMatcher.match(command);
        }

        public boolean matchTable(String name) {
            if (StringKit.isNull(name)) {
                throw new RuntimeException("table name is null");
            }
            name = name.toUpperCase();
            Tuple2<String, String> tup = this.getSchemaAndName(name);
            return this.tablesMatcher.schemaMatcher.match((String)tup.first) && this.tablesMatcher.tableMatcher.match((String)tup.second);
        }

        private Tuple2<String, String> getSchemaAndName(String name) {
            String table;
            String schema;
            String[] list = name == null ? new String[]{""} : StringKit.splitStr(name, ".");
            switch (list.length) {
                case 1: {
                    schema = SelectDatasourceConfig.EMPTY;
                    table = list[0].trim();
                    break;
                }
                case 2: {
                    schema = list[0].trim();
                    table = list[1].trim();
                    break;
                }
                default: {
                    throw new RuntimeException("name segment is error:" + name);
                }
            }
            Tuple2<String, String> tup = Tuple2.with(schema, table);
            return tup;
        }
    }

    public static class TableMatcher {
        StringMatcher schemaMatcher;
        StringMatcher tableMatcher;
    }
}

