/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.dds.impl.kits;

import java.util.HashSet;
import java.util.Set;
import net.jplugin.common.kits.StringKit;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.util.TablesNamesFinder;

public class SchemaCheckKit {
    public static final String E_M_P_T_Y = "E_M_P_T_Y";

    public static Set<String> extractAndRemoveSchema(Statement stmt) {
        return SchemaCheckKit.extractAndRemoveSchema(stmt, true, true);
    }

    public static Set<String> extractAndRemoveSchema(Statement stmt, boolean toUpperCase) {
        return SchemaCheckKit.extractAndRemoveSchema(stmt, toUpperCase, true);
    }

    public static Set<String> extractSchema(Statement stmt, boolean toUpperCase) {
        return SchemaCheckKit.extractAndRemoveSchema(stmt, toUpperCase, false);
    }

    private static Set<String> extractAndRemoveSchema(Statement stmt, boolean toUpperCase, boolean remove) {
        SchemaNameFinderAndRemover snf = new SchemaNameFinderAndRemover(toUpperCase, remove);
        return snf.getSchemas(stmt);
    }

    static class SchemaNameFinderAndRemover
    extends TablesNamesFinder {
        Set<String> schemaNames = new HashSet<String>();
        private boolean needUpperCase;
        private boolean toRemove;

        public SchemaNameFinderAndRemover(boolean upper, boolean remove) {
            this.needUpperCase = upper;
            this.toRemove = remove;
        }

        public Set<String> getSchemas(Statement stmt) {
            this.getTableList(stmt);
            return this.schemaNames;
        }

        public void visit(Table tableName) {
            String name = tableName.getSchemaName();
            if (StringKit.isNull(name)) {
                name = SchemaCheckKit.E_M_P_T_Y;
            } else if (this.toRemove) {
                tableName.setSchemaName(null);
            }
            this.schemaNames.add(this.needUpperCase ? name.toUpperCase() : name);
        }
    }
}

