/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.dds.api;

import java.sql.SQLException;
import net.jplugin.core.config.api.ConfigFactory;
import net.jplugin.core.das.dds.impl.IStatementContextCallable;
import net.jplugin.core.das.dds.kits.SqlParserKit;
import net.jplugin.core.kernel.api.PluginEnvirement;
import net.sf.jsqlparser.statement.Statement;

public class RouterExecutionContext {
    static ThreadLocal<RouterExecutionContext> statementCacheContext = new ThreadLocal();
    static boolean CHECK = "true".equalsIgnoreCase(ConfigFactory.getStringConfigWithTrim("platform.route_ctx_getstmt_with_check"));
    Statement statement = null;

    public static Object call(IStatementContextCallable callable) throws SQLException {
        try {
            return RouterExecutionContext.callInner(callable);
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw e;
            }
            throw new SQLException(e);
        }
    }

    private static Object callInner(IStatementContextCallable callable) throws SQLException {
        RouterExecutionContext ctx = statementCacheContext.get();
        if (ctx == null) {
            try {
                statementCacheContext.set(new RouterExecutionContext());
                Object object = callable.call();
                return object;
            }
            finally {
                statementCacheContext.set(null);
            }
        }
        return callable.call();
    }

    public static RouterExecutionContext get() {
        RouterExecutionContext result = statementCacheContext.get();
        if (result == null) {
            throw new RuntimeException("Not in context now!");
        }
        return result;
    }

    private RouterExecutionContext() {
    }

    public Statement getStatement(String sql) {
        if (this.statement != null) {
            if (CHECK) {
                this.check(sql, this.statement);
            }
            return this.statement;
        }
        this.statement = SqlParserKit.parse(sql);
        return this.statement;
    }

    private void check(String sql, Statement stmt) {
        String stmtString = stmt.toString();
        if (stmtString.equals(sql)) {
            return;
        }
        Statement temp = SqlParserKit.parse(sql);
        if (stmtString.equals(temp.toString())) {
            return;
        }
        throw new RuntimeException("Check Error:sql is " + sql + " statement:" + stmtString);
    }

    static {
        PluginEnvirement.getInstance().getStartLogger().log("$$$ platform.route_ctx_getstmt_with_check =" + CHECK);
    }
}

