/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.api.stat;

import java.util.ArrayList;
import java.util.List;
import net.jplugin.common.kits.AssertKit;
import net.jplugin.common.kits.StringKit;
import net.jplugin.core.das.api.stat.IStatement;
import net.jplugin.core.das.api.stat.ItemPairBasedStatement;
import net.jplugin.core.das.impl.stat.IFromItem;
import net.jplugin.core.das.impl.stat.StringFromItem;
import net.jplugin.core.das.impl.stat.SubQueryFromItem;

public class SelectStatement
extends ItemPairBasedStatement
implements IStatement {
    List<IFromItem> fromList;
    String select;
    String having;
    String groupby;
    String orderby;

    SelectStatement() {
    }

    public static SelectStatement create() {
        return new SelectStatement();
    }

    public static SelectStatement create(String tbname, String select, String where, Object ... para) {
        SelectStatement ss = new SelectStatement();
        if (StringKit.isNotNull(select)) {
            ss.select = select;
        }
        if (StringKit.isNotNull(tbname)) {
            ss.addFrom(tbname, null);
        }
        if (StringKit.isNotNull(where)) {
            ss.addWhere(where, para);
        } else {
            AssertKit.assertTrue(para == null || para.length == 0);
        }
        return ss;
    }

    public void setSelect(String sel) {
        this.select = sel;
    }

    public void setGroupby(String s) {
        this.groupby = s;
    }

    public void setHaving(String s) {
        this.having = s;
    }

    public void setOrderBy(String s) {
        this.orderby = s;
    }

    public void addFrom(String tb, String alias) {
        if (this.fromList == null) {
            this.fromList = new ArrayList<IFromItem>(2);
        }
        AssertKit.assertNotNull(tb, "table or view name");
        AssertKit.assertTrue(tb.indexOf(32) < 0, tb);
        this.fromList.add(new StringFromItem(tb, alias));
    }

    public void addSubQryFrom(SelectStatement ss, String alias) {
        if (this.fromList == null) {
            this.fromList = new ArrayList<IFromItem>(2);
        }
        this.fromList.add(new SubQueryFromItem(ss, alias));
    }

    @Override
    public String getSqlClause() {
        int i;
        AssertKit.assertTrue(StringKit.isNull(this.select) || this.itemPairs == null);
        StringBuffer sb = new StringBuffer("SELECT ");
        if (StringKit.isNotNull(this.select)) {
            sb.append(this.select);
        } else if (this.itemPairs != null) {
            for (i = 0; i < this.itemPairs.size(); ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                ItemPairBasedStatement.ItemPair ip = (ItemPairBasedStatement.ItemPair)this.itemPairs.get(i);
                sb.append(ip.getName()).append(" ");
                if (ip.getValue() == null) continue;
                sb.append(ip.getValue());
            }
        } else {
            throw new RuntimeException("Must have a select item in sql");
        }
        if (this.fromList != null && !this.fromList.isEmpty()) {
            sb.append(" FROM ");
            for (i = 0; i < this.fromList.size(); ++i) {
                IFromItem fi = this.fromList.get(i);
                if (i > 0) {
                    sb.append(",");
                }
                fi.appendToClause(sb);
            }
        }
        super.addWhereClause(sb);
        if (StringKit.isNotNull(this.groupby)) {
            sb.append(" GROUP BY ").append(this.groupby);
        }
        if (StringKit.isNotNull(this.having)) {
            sb.append(" HAVING ").append(this.having);
        }
        if (StringKit.isNotNull(this.orderby)) {
            sb.append(" ORDER BY ").append(this.orderby);
        }
        return sb.toString();
    }

    @Override
    public List<Object> getParams() {
        ArrayList<Object> ret = new ArrayList<Object>();
        if (this.fromList != null) {
            for (IFromItem fi : this.fromList) {
                fi.addToBindList(ret);
            }
        }
        super.addWhereParas(ret);
        return ret;
    }
}

