/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.api.stat;

import java.util.ArrayList;
import java.util.List;
import net.jplugin.common.kits.AssertKit;
import net.jplugin.common.kits.StringKit;
import net.jplugin.core.das.api.stat.IStatement;

public class InsertStatement
implements IStatement {
    String tbName;
    String itemString;
    List<String> itemList;
    String valuesString;
    List<String> valuesList;
    List<Object> bindList;

    private InsertStatement() {
    }

    public static InsertStatement create() {
        return new InsertStatement();
    }

    public static InsertStatement create(String tb, String colsStr, String valuesStr, Object ... para) {
        InsertStatement ret = new InsertStatement();
        if (StringKit.isNotNull(colsStr)) {
            ret.setItemString(colsStr);
        }
        if (StringKit.isNotNull(tb)) {
            ret.setTableName(tb);
        }
        if (StringKit.isNotNull(valuesStr)) {
            ret.setValeusString(valuesStr);
        }
        if (para != null) {
            ret.addParams(para);
        }
        return ret;
    }

    public void setTableName(String nm) {
        this.tbName = nm;
    }

    public void setItemString(String s) {
        this.itemString = s;
    }

    public void setValeusString(String s) {
        this.valuesString = s;
    }

    public void addItem(String s) {
        if (this.itemList == null) {
            this.itemList = new ArrayList<String>();
        }
        this.itemList.add(s);
    }

    public void addValue(String s) {
        if (this.valuesList == null) {
            this.valuesList = new ArrayList<String>();
        }
        this.valuesList.add(s);
    }

    public void addParams(Object[] oarr) {
        for (Object o : oarr) {
            this.addParam(o);
        }
    }

    public void addParam(Object o) {
        if (this.bindList == null) {
            this.bindList = new ArrayList<Object>();
        }
        this.bindList.add(o);
    }

    @Override
    public String getSqlClause() {
        int i;
        AssertKit.assertTrue(StringKit.isNull(this.itemString) || this.itemList == null);
        AssertKit.assertTrue(StringKit.isNull(this.valuesString) || this.valuesList == null);
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ").append(this.tbName);
        if (StringKit.isNotNull(this.itemString)) {
            sb.append("(");
            sb.append(this.itemString);
            sb.append(")");
        } else if (this.itemList != null) {
            sb.append("(");
            for (i = 0; i < this.itemList.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.itemList.get(i));
            }
            sb.append(")");
        }
        sb.append(" VALUES (");
        if (this.valuesString != null) {
            sb.append(this.valuesString);
        } else if (this.valuesList != null) {
            for (i = 0; i < this.valuesList.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.valuesList.get(i));
            }
        }
        sb.append(" )");
        return sb.toString();
    }

    @Override
    public List<Object> getParams() {
        if (this.bindList == null) {
            return new ArrayList<Object>(0);
        }
        return this.bindList;
    }
}

