/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.api.impl;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import javax.sql.DataSource;
import net.jplugin.core.ctx.api.TransactionHandler;
import net.jplugin.core.ctx.api.TransactionManager;
import net.jplugin.core.das.api.impl.ConnStaticsKit;
import net.jplugin.core.das.api.impl.TxManagedConnAdaptor;
import net.jplugin.core.kernel.api.ctx.ThreadLocalContext;
import net.jplugin.core.kernel.api.ctx.ThreadLocalContextListener;
import net.jplugin.core.kernel.api.ctx.ThreadLocalContextManager;
import net.jplugin.core.log.api.ILogService;
import net.jplugin.core.log.api.Logger;
import net.jplugin.core.service.api.ServiceFactory;

public class TxManagedDataSource
implements DataSource,
TransactionHandler {
    private String DBCONN_IN_CTX;
    private static final String DBCONN_IN_CTX_PREFIX = "DBCONN_IN_CTX";
    DataSource inner;

    public TxManagedDataSource(String ds, DataSource in) {
        this.inner = in;
        this.DBCONN_IN_CTX = "DBCONN_IN_CTX#" + ds;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.inner.getLogWriter();
    }

    public DataSource getInner() {
        return this.inner;
    }

    @Override
    public Connection getConnection() throws SQLException {
        final ThreadLocalContext ctx = ThreadLocalContextManager.instance.getContext();
        TxManagedConnAdaptor conn = (TxManagedConnAdaptor)ctx.getAttribute(this.DBCONN_IN_CTX);
        if (conn != null) {
            return conn;
        }
        conn = new TxManagedConnAdaptor(this.inner.getConnection());
        ConnStaticsKit.INSTANCE.logGetConn();
        ctx.setAttribute(this.DBCONN_IN_CTX, conn);
        ctx.addContextListener(new ThreadLocalContextListener(){

            @Override
            public void released(ThreadLocalContext rc) {
                TxManagedConnAdaptor temp = (TxManagedConnAdaptor)ctx.getAttribute(TxManagedDataSource.this.DBCONN_IN_CTX);
                if (temp != null) {
                    try {
                        if (!temp.isClosed()) {
                            ConnStaticsKit.INSTANCE.logCloseConn();
                            temp.connection().close();
                        }
                    }
                    catch (SQLException e) {
                        Logger logger = ServiceFactory.getService(ILogService.class).getLogger(this.getClass().getName());
                        logger.error(e);
                    }
                }
            }
        });
        TransactionManager txm = ServiceFactory.getService(TransactionManager.class);
        if (txm.getStatus() != TransactionManager.Status.NOTX) {
            conn.connection().setAutoCommit(false);
        } else {
            conn.connection().setAutoCommit(true);
        }
        return conn;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new RuntimeException("not support");
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.inner.getLoginTimeout();
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.inner.getParentLogger();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.inner.isWrapperFor(iface);
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.inner.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.inner.setLoginTimeout(seconds);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.inner.unwrap(iface);
    }

    @Override
    public void doBegin() {
        ThreadLocalContext ctx = ThreadLocalContextManager.instance.getContext();
        TxManagedConnAdaptor conn = (TxManagedConnAdaptor)ctx.getAttribute(this.DBCONN_IN_CTX);
        if (conn != null) {
            try {
                ConnStaticsKit.INSTANCE.logCloseConn();
                conn.connection().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ctx.setAttribute(this.DBCONN_IN_CTX, null);
        }
    }

    @Override
    public void doRollback() {
        ThreadLocalContext ctx = ThreadLocalContextManager.instance.getContext();
        TxManagedConnAdaptor conn = (TxManagedConnAdaptor)ctx.getAttribute(this.DBCONN_IN_CTX);
        if (conn != null) {
            try {
                conn.connection().rollback();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    ConnStaticsKit.INSTANCE.logCloseConn();
                    conn.connection().close();
                }
                catch (Exception exception) {}
                ctx.setAttribute(this.DBCONN_IN_CTX, null);
            }
        }
    }

    @Override
    public void doCommit() {
        ThreadLocalContext ctx = ThreadLocalContextManager.instance.getContext();
        TxManagedConnAdaptor conn = (TxManagedConnAdaptor)ctx.getAttribute(this.DBCONN_IN_CTX);
        if (conn != null) {
            try {
                conn.connection().commit();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    ConnStaticsKit.INSTANCE.logCloseConn();
                    conn.connection().close();
                }
                catch (Exception exception) {}
                ctx.setAttribute(this.DBCONN_IN_CTX, null);
            }
        }
    }
}

