/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.api.impl;

import java.util.Map;
import javax.sql.DataSource;
import net.jplugin.common.kits.ReflactKit;
import net.jplugin.common.kits.StringKit;
import net.jplugin.core.config.api.ConfigFactory;
import net.jplugin.core.das.api.dds.DDSManager;
import net.jplugin.core.das.dds.api.AbstractRouterDataSource;
import net.jplugin.core.das.dds.api.RouterException;
import org.apache.commons.dbcp2.BasicDataSource;

public class ConfigedDataSource {
    public static DataSource getDataSource(String group) {
        Map<String, String> map = ConfigFactory.getStringConfigInGroup(group);
        String routeFlag = map.get("route-datasource-flag");
        if (routeFlag != null) {
            routeFlag.trim();
        }
        if ("true".equalsIgnoreCase(routeFlag)) {
            String routeDatasourceType = map.get("route-datasource-type");
            if (StringKit.isNull(routeDatasourceType)) {
                routeDatasourceType = "db-table-split";
            }
            Class clazz = DDSManager.me.getDataSourceClassByType(routeDatasourceType);
            String routeDatasourceClass = clazz.getName();
            AbstractRouterDataSource ds = ConfigedDataSource.makeRouteDataSource(routeDatasourceClass, group, map);
            return ds;
        }
        DataSource ds = ConfigedDataSource.createJdbcDataSource(group, map);
        return ds;
    }

    private static AbstractRouterDataSource makeRouteDataSource(String routeDatasourceClass, String dsname, Map<String, String> map) {
        AbstractRouterDataSource o;
        try {
            o = (AbstractRouterDataSource)Class.forName(routeDatasourceClass).newInstance();
        }
        catch (Exception e) {
            throw new RouterException("create instance error:" + routeDatasourceClass, e);
        }
        o.init(dsname, map);
        return o;
    }

    private static DataSource createJdbcDataSource(String group, Map<String, String> map) {
        BasicDataSource ds = new BasicDataSource();
        if (map.containsKey("dbuser")) {
            map.put("username", map.get("dbuser"));
            map.remove("dbuser");
        }
        if (map.containsKey("dbpassword")) {
            map.put("password", map.get("dbpassword"));
            map.remove("dbpassword");
        }
        ConfigedDataSource.compibleWithDBCP1(map);
        map.remove("is-tx-managed");
        if (map.isEmpty()) {
            throw new RuntimeException("Can't find config for database:" + group);
        }
        for (String k : map.keySet()) {
            ReflactKit.setPropertyFromString(ds, k, map.get(k));
        }
        return ds;
    }

    private static void compibleWithDBCP1(Map<String, String> map) {
        String o;
        if (map.containsKey("maxWait")) {
            o = map.get("maxWait");
            map.remove("maxWait");
            map.put("maxWaitMillis", o);
        }
        if (map.containsKey("maxActive")) {
            o = map.get("maxActive");
            map.remove("maxActive");
            map.put("maxTotal", o);
        }
    }
}

