/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.api;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jplugin.common.kits.JsonKit;
import net.jplugin.common.kits.ObjectRef;
import net.jplugin.common.kits.tuple.Tuple3;
import net.jplugin.core.das.api.DataException;
import net.jplugin.core.das.api.IResultDisposer;

public class SQLTemplate {
    public static boolean printSQL = true;

    public static int executeUpdateSql(Connection conn, String sql, Object[] param) {
        if (printSQL) {
            SQLTemplate.print(sql, param);
        }
        return SQLTemplate.executeAndReturnCount(conn, sql, param, "UPDATE");
    }

    private static void print(String sql, Object[] param) {
        System.out.print("SQL:" + sql + " params=" + JsonKit.object2Json(param));
        System.out.println();
    }

    public static int executeDeleteSql(Connection conn, String sql, Object[] param) {
        if (printSQL) {
            SQLTemplate.print(sql, param);
        }
        return SQLTemplate.executeAndReturnCount(conn, sql, param, "DELETE");
    }

    static int executeAndReturnCount(Connection conn, String sql, Object[] param, String prefixIgnorecase) {
        int n;
        Statement stmt;
        block7: {
            String leftTenChar = sql.substring(0, 10);
            if (!leftTenChar.trim().toUpperCase().startsWith(prefixIgnorecase)) {
                throw new DataException("Not a valid sql with " + prefixIgnorecase);
            }
            stmt = null;
            if (param != null && param.length != 0) break block7;
            stmt = conn.createStatement();
            int n2 = stmt.executeUpdate(sql);
            SQLTemplate.closeStmtQuiretly(stmt);
            return n2;
        }
        try {
            int ret;
            stmt = conn.prepareStatement(sql);
            for (int i = 0; i < param.length; ++i) {
                ((PreparedStatement)stmt).setObject(i + 1, param[i]);
            }
            n = ret = ((PreparedStatement)stmt).executeUpdate();
        }
        catch (Exception e) {
            try {
                throw new DataException(e.getMessage() + "SQL\u6267\u884c\u5931\u8d25\u3002 SQL=" + sql, e);
            }
            catch (Throwable throwable) {
                SQLTemplate.closeStmtQuiretly(stmt);
                throw throwable;
            }
        }
        SQLTemplate.closeStmtQuiretly(stmt);
        return n;
    }

    private static void closeStmtQuiretly(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void executeDropSql(Connection connection, String sql) {
        if (printSQL) {
            SQLTemplate.print(sql, null);
        }
        SQLTemplate.executeAndReturnCount(connection, sql, null, "DROP");
    }

    public static void executeCreateSql(Connection connection, String sql) {
        if (printSQL) {
            SQLTemplate.print(sql, null);
        }
        SQLTemplate.executeAndReturnCount(connection, sql, null, "CREATE");
    }

    public static List<Long> executeInsertReturnGenKey(Connection conn, String sql, Object[] param) {
        List<Long> list;
        Statement stmt;
        block7: {
            if (!sql.trim().toUpperCase().startsWith("INSERT")) {
                throw new DataException("Not a insert sql");
            }
            stmt = null;
            if (param != null && param.length != 0) break block7;
            stmt = conn.createStatement();
            stmt.executeUpdate(sql, 1);
            List<Long> list2 = SQLTemplate.getGenKey(stmt);
            SQLTemplate.closeStmtQuiretly(stmt);
            return list2;
        }
        try {
            stmt = conn.prepareStatement(sql, 1);
            for (int i = 0; i < param.length; ++i) {
                ((PreparedStatement)stmt).setObject(i + 1, param[i]);
            }
            int ret = ((PreparedStatement)stmt).executeUpdate();
            list = SQLTemplate.getGenKey(stmt);
        }
        catch (Exception e) {
            try {
                throw new DataException(e.getMessage() + "SQL\u6267\u884c\u5931\u8d25\u3002 SQL=" + sql, e);
            }
            catch (Throwable throwable) {
                SQLTemplate.closeStmtQuiretly(stmt);
                throw throwable;
            }
        }
        SQLTemplate.closeStmtQuiretly(stmt);
        return list;
    }

    private static List<Long> getGenKey(Statement stmt) throws SQLException {
        ResultSet genkeys = stmt.getGeneratedKeys();
        ArrayList<Long> ret = new ArrayList<Long>();
        while (genkeys.next()) {
            long key = genkeys.getLong(1);
            ret.add(key);
        }
        return ret;
    }

    public static int executeInsertSql(Connection connection, String sql, Object[] param) {
        if (printSQL) {
            SQLTemplate.print(sql, param);
        }
        return SQLTemplate.executeAndReturnCount(connection, sql, param, "INSERT");
    }

    public static List<Map<String, String>> executeSelect(Connection conn, String sql, Object[] p) {
        return (List)SQLTemplate.executeSelectWithMeta((Connection)conn, (String)sql, (Object[])p, (boolean)false).first;
    }

    public static Tuple3<List<Map<String, String>>, List<String>, List<Integer>> executeSelectWithMeta(Connection conn, String sql, Object[] p, final boolean needMeta) {
        final ArrayList ret = new ArrayList();
        final ObjectRef columnsRef = new ObjectRef();
        final ObjectRef typesRef = new ObjectRef();
        SQLTemplate.executeSelect(conn, sql, new IResultDisposer(){
            List<String> columns = null;
            List<Integer> types = null;

            @Override
            public void readRow(ResultSet rs) throws SQLException {
                if (this.columns == null) {
                    this.initcolumns(rs);
                }
                HashMap<String, String> map = new HashMap<String, String>();
                for (String s : this.columns) {
                    map.put(s, rs.getString(s));
                }
                ret.add(map);
            }

            private void initcolumns(ResultSet rs) throws SQLException {
                int i;
                ResultSetMetaData m = rs.getMetaData();
                int cnt = m.getColumnCount();
                this.columns = new ArrayList<String>();
                for (i = 1; i <= cnt; ++i) {
                    this.columns.add(m.getColumnLabel(i));
                }
                columnsRef.set(this.columns);
                if (needMeta) {
                    this.types = new ArrayList<Integer>();
                    for (i = 1; i <= cnt; ++i) {
                        this.types.add(m.getColumnType(i));
                    }
                    typesRef.set(this.types);
                }
            }
        }, p);
        if (needMeta) {
            return Tuple3.with(ret, columnsRef.get(), typesRef.get());
        }
        return Tuple3.with(ret, null, null);
    }

    public static void executeSelect(Connection conn, String sql, IResultDisposer rd, Object[] param) {
        ResultSet rs;
        Statement stmt;
        block8: {
            String leftTenChar;
            if (printSQL) {
                SQLTemplate.print(sql, param);
            }
            if (!(leftTenChar = sql.substring(0, 10)).trim().toUpperCase().startsWith("SELECT")) {
                throw new DataException("Not a valid sql with SELECT");
            }
            stmt = null;
            rs = null;
            try {
                if (param == null || param.length == 0) {
                    stmt = conn.createStatement();
                    rs = stmt.executeQuery(sql);
                    SQLTemplate.fetchRs(rs, rd);
                    break block8;
                }
                stmt = conn.prepareStatement(sql);
                for (int i = 0; i < param.length; ++i) {
                    ((PreparedStatement)stmt).setObject(i + 1, param[i]);
                }
                rs = ((PreparedStatement)stmt).executeQuery();
                SQLTemplate.fetchRs(rs, rd);
            }
            catch (Exception e) {
                try {
                    throw new DataException(e.getMessage() + " SQL=" + sql, e);
                }
                catch (Throwable throwable) {
                    SQLTemplate.closeResultSetQuiertly(rs);
                    SQLTemplate.closeStmtQuiretly(stmt);
                    throw throwable;
                }
            }
        }
        SQLTemplate.closeResultSetQuiertly(rs);
        SQLTemplate.closeStmtQuiretly(stmt);
    }

    private static void closeResultSetQuiertly(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void fetchRs(ResultSet rs, IResultDisposer rd) throws SQLException {
        while (rs.next()) {
            rd.readRow(rs);
        }
    }
}

