/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.api;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import net.jplugin.core.config.api.ConfigFactory;
import net.jplugin.core.ctx.api.TransactionManager;
import net.jplugin.core.das.api.impl.ConfigedDataSource;
import net.jplugin.core.das.api.impl.DataSourceAutoFindUtil;
import net.jplugin.core.das.api.impl.DataSourceDefinition;
import net.jplugin.core.das.api.impl.DataSourceWrapper;
import net.jplugin.core.das.api.impl.DynamicDataSourceManager;
import net.jplugin.core.das.api.impl.TxManagedDataSource;
import net.jplugin.core.kernel.api.PluginEnvirement;
import net.jplugin.core.service.api.ServiceFactory;

public class DataSourceFactory {
    public static final String DATABASE_DSKEY = "database";
    public static final String IS_TX_MANAGED = "is-tx-managed";
    private static Map<String, DataSource> map = new Hashtable<String, DataSource>();
    private static boolean inited = false;

    public static synchronized void init() {
        if (inited) {
            return;
        }
        inited = true;
        HashMap<String, DataSourceDefinition> dss = new HashMap<String, DataSourceDefinition>();
        dss.putAll(PluginEnvirement.getInstance().getExtensionMap("EP_DATASOURCE", DataSourceDefinition.class));
        List<String> allConfigedNames = DataSourceAutoFindUtil.getAllDataSourceNames();
        for (String string : allConfigedNames) {
            if (dss.containsKey(string)) continue;
            DataSourceDefinition dsd = new DataSourceDefinition();
            dsd.setConfigGroupName(string);
            dsd.setManaged(true);
            if ("false".equalsIgnoreCase(ConfigFactory.getStringConfig(string + "." + IS_TX_MANAGED))) {
                dsd.setManaged(false);
            } else {
                dsd.setManaged(true);
            }
            dss.put(string, dsd);
        }
        for (Map.Entry entry : dss.entrySet()) {
            DataSource dataSource = ConfigedDataSource.getDataSource(((DataSourceDefinition)entry.getValue()).getConfigGroupName());
            if (((DataSourceDefinition)entry.getValue()).getManaged()) {
                TxManagedDataSource managedDataSource = new TxManagedDataSource((String)entry.getKey(), dataSource);
                map.put((String)entry.getKey(), new DataSourceWrapper((String)entry.getKey(), managedDataSource));
                ServiceFactory.getService(TransactionManager.class).addTransactionHandler(managedDataSource);
                continue;
            }
            map.put((String)entry.getKey(), new DataSourceWrapper((String)entry.getKey(), dataSource));
        }
        if ("true".equalsIgnoreCase(ConfigFactory.getStringConfig("platform.use-dynamic-datasource-old-version"))) {
            DataSourceFactory.addDynamicDataSourceToMap();
        }
    }

    private static void addDynamicDataSourceToMap() {
        Map<String, DataSource> dmap = DynamicDataSourceManager.INSTANCE.getDataSoruceMap();
        for (Map.Entry<String, DataSource> en : dmap.entrySet()) {
            if (map.containsKey(en.getKey())) {
                throw new RuntimeException("duplicate dataSource Name for dynamic:" + en.getKey());
            }
            map.put(en.getKey(), en.getValue());
        }
    }

    public static Set<String> getDataSourceNames() {
        return map.keySet();
    }

    public static DataSource getDataSource(String dataSourceName) {
        DataSource ds = map.get(dataSourceName);
        if (ds == null) {
            throw new RuntimeException("Can't find datasource config for:" + dataSourceName);
        }
        return ds;
    }
}

