/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.ctx.impl.filter4clazz;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.jplugin.common.kits.filter.FilterChain;
import net.jplugin.common.kits.filter.FilterManager;
import net.jplugin.common.kits.filter.IFilter;
import net.jplugin.core.ctx.api.AbstractRuleMethodInterceptor;
import net.jplugin.core.ctx.api.IRuleServiceFilter;
import net.jplugin.core.ctx.api.RuleServiceFilterContext;
import net.jplugin.core.ctx.impl.filter4clazz.RuleCallFilterDefine;
import net.jplugin.core.ctx.impl.filter4clazz.RuleCallFilterDefineManager;

public class RuleCallFilterManagerRuleFilter
implements IRuleServiceFilter {
    private static final Object EMPTY_OBJECT = new Object(){

        public String toString() {
            return "EMPTY_OBJECT";
        }
    };
    ConcurrentHashMap<Class, Object> filterManagers = new ConcurrentHashMap();

    @Override
    public Object filter(FilterChain fc, RuleServiceFilterContext ctx) throws Throwable {
        Class<?> clazz = ctx.getMethod().getDeclaringClass();
        Object fm = this.findFilterManager(clazz, fc);
        if (fm == EMPTY_OBJECT) {
            return fc.next(ctx);
        }
        return ((FilterManager)fm).filter(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object findFilterManager(Class clazz, FilterChain chain) {
        Object ret = this.filterManagers.get(clazz);
        if (ret != null) {
            return ret;
        }
        ConcurrentHashMap<Class, Object> concurrentHashMap = this.filterManagers;
        synchronized (concurrentHashMap) {
            ret = this.filterManagers.get(clazz);
            if (ret == null) {
                FilterManager<RuleServiceFilterContext> fm = this.tryCreateFilterManager(clazz, chain);
                if (fm != null) {
                    this.filterManagers.put(clazz, fm);
                } else {
                    this.filterManagers.put(clazz, EMPTY_OBJECT);
                }
            }
        }
        return this.filterManagers.get(clazz);
    }

    private FilterManager<RuleServiceFilterContext> tryCreateFilterManager(Class clazz, FilterChain chain) {
        List<RuleCallFilterDefine> list = RuleCallFilterDefineManager.INSTANCE.getMatchedDefinesForClass(clazz);
        if (list.isEmpty() || list == null) {
            return null;
        }
        FilterManager<RuleServiceFilterContext> fm = new FilterManager<RuleServiceFilterContext>();
        for (RuleCallFilterDefine rcfd : list) {
            ClassOwnedFilter filter = this.createClassOwnedFilter(rcfd);
            fm.addFilter(filter);
        }
        List filters = chain.getFollowingFilters();
        for (IFilter f : filters) {
            fm.addFilter(f);
        }
        return fm;
    }

    private synchronized ClassOwnedFilter createClassOwnedFilter(RuleCallFilterDefine filterDefine) {
        return new ClassOwnedFilter(filterDefine, filterDefine.getFilterInstance());
    }

    static class ClassOwnedFilter
    implements IFilter<RuleServiceFilterContext> {
        private RuleCallFilterDefine filterDefine;
        private AbstractRuleMethodInterceptor ruleInterceptor;

        public ClassOwnedFilter(RuleCallFilterDefine fd, AbstractRuleMethodInterceptor inceptor) {
            this.filterDefine = fd;
            this.ruleInterceptor = inceptor;
        }

        @Override
        public Object filter(FilterChain fc, RuleServiceFilterContext ctx) throws Throwable {
            return this.ruleInterceptor.filter(fc, ctx, this.filterDefine);
        }
    }
}

