/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.ctx.impl.filter4clazz;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.jplugin.common.kits.SortUtil;
import net.jplugin.core.ctx.api.AbstractRuleMethodInterceptor;
import net.jplugin.core.ctx.impl.filter4clazz.RuleCallFilterDefine;
import net.jplugin.core.ctx.impl.filter4clazz.RuleCallFilterDefineBean;
import net.jplugin.core.kernel.api.Beans;
import net.jplugin.core.kernel.api.PluginEnvirement;

public class RuleCallFilterDefineManager {
    public static RuleCallFilterDefineManager INSTANCE = new RuleCallFilterDefineManager();
    RuleCallFilterDefineBean[] defSetList;
    List<RuleCallFilterDefine> defList;

    public void initialize() {
        HashMap<Class, AbstractRuleMethodInterceptor> filterInstanceMap = new HashMap<Class, AbstractRuleMethodInterceptor>();
        this.defSetList = PluginEnvirement.getInstance().getExtensionObjects("EP_RULE_METHOD_INTERCEPTOR", RuleCallFilterDefineBean.class);
        this.defList = new ArrayList<RuleCallFilterDefine>();
        for (RuleCallFilterDefineBean ds : this.defSetList) {
            List<RuleCallFilterDefine> list;
            AbstractRuleMethodInterceptor instance = this.getOrCreateFilterInstance(ds.getFilterClass(), filterInstanceMap);
            Beans.resetValue(ds, instance);
            try {
                list = RuleCallFilterDefine.parse(ds.getApplyTo());
            }
            catch (Exception e) {
                throw new RuntimeException("Binding annotation error, applyto= " + ds.getApplyTo() + " filter=" + ds.getFilterClass().getName(), e);
            }
            for (RuleCallFilterDefine cmfd : list) {
                if (!AbstractRuleMethodInterceptor.class.isAssignableFrom(ds.getFilterClass())) {
                    throw new RuntimeException(ds.getFilterClass().getName() + " is not subclass of " + AbstractRuleMethodInterceptor.class);
                }
                cmfd.setPriority(ds.getPriority());
                cmfd.setFilterClazz(ds.getFilterClass());
                cmfd.setFilterInstance(instance);
                this.defList.add(cmfd);
            }
        }
    }

    private AbstractRuleMethodInterceptor getOrCreateFilterInstance(Class filterClazz, HashMap<Class, AbstractRuleMethodInterceptor> cache) {
        AbstractRuleMethodInterceptor inteceptor = cache.get(filterClazz);
        if (inteceptor == null) {
            try {
                inteceptor = (AbstractRuleMethodInterceptor)filterClazz.newInstance();
                PluginEnvirement.INSTANCE.resolveRefAnnotation(inteceptor);
                cache.put(filterClazz, inteceptor);
            }
            catch (Exception e) {
                throw new RuntimeException("can't init object :" + filterClazz.getName(), e);
            }
        }
        return inteceptor;
    }

    public List<RuleCallFilterDefine> getMatchedDefinesForClass(Class c) {
        ArrayList<RuleCallFilterDefine> ret = new ArrayList<RuleCallFilterDefine>();
        for (RuleCallFilterDefine o : this.defList) {
            if (!o.matchClazz(c.getName())) continue;
            ret.add(o);
        }
        SortUtil.sort(ret, (o1, o2) -> ((RuleCallFilterDefine)o1).getPriority() > ((RuleCallFilterDefine)o2).getPriority());
        return ret;
    }
}

