/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.ctx.impl.filter4clazz;

import java.util.ArrayList;
import java.util.List;
import net.jplugin.common.kits.StringKit;
import net.jplugin.common.kits.StringMatcher;
import net.jplugin.core.ctx.api.AbstractRuleMethodInterceptor;

public class RuleCallFilterDefine {
    private StringMatcher methodMatcher;
    private StringMatcher classMatcher;
    private int priority;
    private Class filterClazz;
    private AbstractRuleMethodInterceptor filterInstance;

    public String toString() {
        StringBuffer sb = new StringBuffer("{");
        sb.append("classMatcher=" + this.classMatcher).append(" ");
        sb.append("methodMatcher=" + this.methodMatcher).append(" ");
        sb.append("}");
        return sb.toString();
    }

    public RuleCallFilterDefine(String classFormat, String methodFormat) {
        this.classMatcher = new StringMatcher(classFormat);
        this.methodMatcher = new StringMatcher(methodFormat);
    }

    public boolean matchClazz(String clazz) {
        return this.classMatcher.match(clazz);
    }

    public boolean matchMethod(String method) {
        return this.methodMatcher.match(method);
    }

    public static List<RuleCallFilterDefine> parse(String strDefine) {
        String[] strlist;
        ArrayList<RuleCallFilterDefine> ret = new ArrayList<RuleCallFilterDefine>();
        if (StringKit.isNull(strDefine)) {
            throw new RuntimeException("[applyTo] must not null ,if match all . should use *");
        }
        if (strDefine.startsWith(",") || strDefine.endsWith(",")) {
            throw new RuntimeException("format error:" + strDefine);
        }
        for (String s : strlist = StringKit.splitStr(strDefine, ",")) {
            if (s == null || s.equals("")) {
                throw new RuntimeException("parse string for define error:" + strDefine);
            }
            ret.add(RuleCallFilterDefine.createDefine(s));
        }
        return ret;
    }

    private static RuleCallFilterDefine createDefine(String s) {
        String methodFilter;
        String clazz;
        String[] arr = StringKit.splitStr(s, ":");
        if (arr.length > 2) {
            throw new RuntimeException("error format for ClassMethodFilterDefine:" + s);
        }
        if (arr.length == 1) {
            clazz = arr[0];
            methodFilter = null;
        } else if (arr.length == 2) {
            clazz = arr[0];
            methodFilter = arr[1];
            if (StringKit.isNull(methodFilter)) {
                throw new RuntimeException("Method filter is null." + s);
            }
        } else {
            throw new RuntimeException("shoudln't come here." + s);
        }
        RuleCallFilterDefine def = new RuleCallFilterDefine(clazz, methodFilter);
        return def;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public Class getFilterClazz() {
        return this.filterClazz;
    }

    public void setFilterClazz(Class filterClazz) {
        this.filterClazz = filterClazz;
    }

    public void setFilterInstance(AbstractRuleMethodInterceptor instance) {
        this.filterInstance = instance;
    }

    public AbstractRuleMethodInterceptor getFilterInstance() {
        return this.filterInstance;
    }
}

