/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.ctx.impl;

import java.util.ArrayList;
import java.util.List;
import net.jplugin.core.ctx.api.TransactionManager;
import net.jplugin.core.ctx.api.TransactionSync;
import net.jplugin.core.ctx.impl.TxRuntimeException;
import net.jplugin.core.log.api.ILogService;
import net.jplugin.core.log.api.Logger;
import net.jplugin.core.service.api.ServiceFactory;

public class TransactionObject {
    TransactionManager.Status status = TransactionManager.Status.NOTX;
    List<TransactionSync> syncs = null;
    private static Logger logger;

    public void setStatus(TransactionManager.Status status) {
        this.status = status;
    }

    public TransactionManager.Status getStatus() {
        return this.status;
    }

    public boolean containsSync(TransactionSync sync) {
        if (this.status == TransactionManager.Status.NOTX) {
            throw new TxRuntimeException("not in transaction");
        }
        if (this.syncs == null) {
            return false;
        }
        return this.syncs.contains(sync);
    }

    public void addSync(TransactionSync sync) {
        if (this.status == TransactionManager.Status.NOTX) {
            throw new TxRuntimeException("not in transaction");
        }
        if (this.syncs == null) {
            this.syncs = new ArrayList<TransactionSync>(3);
        }
        if (this.syncs.contains(sync)) {
            throw new RuntimeException("the sync already exists");
        }
        this.syncs.add(sync);
    }

    public void removeSync(TransactionSync s) {
        if (this.status == TransactionManager.Status.NOTX) {
            throw new TxRuntimeException("not in transaction");
        }
        if (this.syncs == null) {
            return;
        }
        this.syncs.remove(s);
    }

    public void notifyTxBegin() {
        if (this.syncs != null && !this.syncs.isEmpty()) {
            TransactionObject.getLogger().error("\u53d1\u751f\u4e86\u4e0d\u5e94\u8be5\u53d1\u751f\u7684\u95ee\u9898\uff0c\u4e8b\u7269\u540c\u6b65\u6ca1\u6709\u6e05\u7406\u6389!!!!!!");
            this.syncs.clear();
        }
    }

    public void notifyBeforeCompletion() {
        if (this.syncs == null) {
            return;
        }
        for (TransactionSync s : this.syncs) {
            s.beforeCompletion();
        }
    }

    public void notifyAfterCommit(Throwable th) {
        if (this.syncs == null) {
            return;
        }
        if (th == null) {
            Throwable theNewTh = null;
            for (TransactionSync s : this.syncs) {
                try {
                    s.afterCompletion(true, null);
                }
                catch (Throwable newTh) {
                    this.logError("Exception in transaction sync:1", newTh);
                    if (theNewTh != null) continue;
                    theNewTh = newTh;
                }
            }
            this.syncs.clear();
            if (theNewTh != null) {
                if (theNewTh instanceof RuntimeException) {
                    throw (RuntimeException)theNewTh;
                }
                throw new RuntimeException(theNewTh.getMessage(), theNewTh);
            }
        } else {
            for (TransactionSync s : this.syncs) {
                try {
                    s.afterCompletion(false, th);
                }
                catch (Throwable e) {
                    this.logError("Exception in transaction sync:1", e);
                }
            }
            this.syncs.clear();
        }
    }

    public void notifyAfterRollback(Throwable th) {
        if (this.syncs == null) {
            return;
        }
        for (TransactionSync s : this.syncs) {
            try {
                s.afterCompletion(false, th);
            }
            catch (Throwable e) {
                this.logError("Exception in transaction sync:2", e);
            }
        }
        this.syncs.clear();
    }

    private void logError(String string, Throwable e) {
        TransactionObject.getLogger().error((Object)string, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Logger getLogger() {
        if (logger != null) return logger;
        Class<TransactionObject> clazz = TransactionObject.class;
        synchronized (TransactionObject.class) {
            if (logger != null) return logger;
            logger = ServiceFactory.getService(ILogService.class).getLogger(TransactionObject.class.getName());
            // ** MonitorExit[var0] (shouldn't be in output)
            return logger;
        }
    }
}

