/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.ctx.impl;

import net.jplugin.core.ctx.api.RollBackException;
import net.jplugin.core.ctx.api.TransactionHandler;
import net.jplugin.core.ctx.api.TransactionManager;
import net.jplugin.core.ctx.api.TransactionSync;
import net.jplugin.core.ctx.impl.TransactionObject;
import net.jplugin.core.ctx.impl.TxRuntimeException;
import net.jplugin.core.log.api.ILogService;
import net.jplugin.core.log.api.Logger;
import net.jplugin.core.service.api.ServiceFactory;

public class TransactionManagerImpl
implements TransactionManager {
    TransactionHandler[] handlers = new TransactionHandler[0];
    ThreadLocal<TransactionObject> txObject = new ThreadLocal<TransactionObject>(){

        @Override
        protected TransactionObject initialValue() {
            return new TransactionObject();
        }
    };
    private Logger logger;

    @Override
    public void begin() {
        int pos;
        if (this.txObject.get().getStatus() != TransactionManager.Status.NOTX) {
            throw new RuntimeException("tx state not right");
        }
        try {
            for (pos = 0; pos < this.handlers.length; ++pos) {
                this.handlers[pos].doBegin();
            }
        }
        catch (Throwable e) {
            this.rollbackPreviousSilently(pos - 1);
            throw new TxRuntimeException("\u542f\u52a8\u4e8b\u52a1\u53d1\u751f\u5f02\u5e38", e);
        }
        this.txObject.get().setStatus(TransactionManager.Status.INTX);
        this.txObject.get().notifyTxBegin();
    }

    @Override
    public void commit() {
        int pos;
        TransactionManager.Status currnetState = this.txObject.get().getStatus();
        if (currnetState != TransactionManager.Status.INTX && currnetState != TransactionManager.Status.MARKED_ROLLBACK) {
            throw new RuntimeException("tx state not right");
        }
        if (currnetState == TransactionManager.Status.MARKED_ROLLBACK) {
            this.rollbackAllSilently();
            throw new RollBackException("tx marked roll back");
        }
        this.txObject.get().notifyBeforeCompletion();
        TxRuntimeException theException = null;
        try {
            for (pos = 0; pos < this.handlers.length; ++pos) {
                this.handlers[pos].doCommit();
            }
        }
        catch (Throwable e) {
            this.commitFollowingsSilently(pos + 1);
            theException = new TxRuntimeException(this.handlers.length > 1 ? "\u4e8b\u52a1\u63d0\u4ea4\u5f02\u5e38\uff0c\u56e0\u4e3a\u6709\u591a\u4e2a\u4e8b\u52a1\u5904\u7406\u5668\uff0c\u53ef\u80fd\u4e0d\u5b8c\u5168\u63d0\u4ea4" : "\u4e8b\u52a1\u63d0\u4ea4\u5f02\u5e38", e);
            throw theException;
        }
        finally {
            this.txObject.get().setStatus(TransactionManager.Status.NOTX);
            this.txObject.get().notifyAfterCommit(theException);
        }
    }

    @Override
    public void rollback() {
        int pos;
        TransactionManager.Status currnetState = this.txObject.get().getStatus();
        if (currnetState == TransactionManager.Status.NOTX) {
            return;
        }
        if (currnetState != TransactionManager.Status.INTX && currnetState != TransactionManager.Status.MARKED_ROLLBACK) {
            throw new RuntimeException("tx state not right");
        }
        TxRuntimeException theException = null;
        try {
            for (pos = 0; pos < this.handlers.length; ++pos) {
                this.handlers[pos].doRollback();
            }
        }
        catch (Throwable e) {
            this.rollbackFollowingsSilently(pos);
            theException = new TxRuntimeException(this.handlers.length > 1 ? "\u4e8b\u52a1\u56de\u6eda\u5f02\u5e38\uff0c\u56e0\u4e3a\u6709\u591a\u4e2a\u4e8b\u52a1\u5904\u7406\u5668\uff0c\u53ef\u80fd\u4e0d\u5b8c\u5168\u56de\u6eda" : "\u4e8b\u52a1\u56de\u6eda\u5f02\u5e38", e);
            throw theException;
        }
        finally {
            this.txObject.get().setStatus(TransactionManager.Status.NOTX);
            this.txObject.get().notifyAfterRollback(theException);
        }
    }

    @Override
    public void setRollbackOnly() {
        this.txObject.get().setStatus(TransactionManager.Status.MARKED_ROLLBACK);
    }

    private void commitFollowingsSilently(int index) {
        for (int i = index; i < this.handlers.length; ++i) {
            try {
                this.handlers[i].doCommit();
                continue;
            }
            catch (Throwable th) {
                this.getLogger().error((Object)"\u63d0\u4ea4\u540e\u7eed\u4e8b\u52a1\u5904\u7406\u5668\u65f6\u5f02\u5e38", th);
            }
        }
    }

    private void rollbackAllSilently() {
        this.rollbackPreviousSilently(this.handlers.length - 1);
    }

    private void rollbackPreviousSilently(int pos) {
        for (int i = pos; i >= 0; --i) {
            try {
                this.handlers[i].doRollback();
                continue;
            }
            catch (Throwable th) {
                this.getLogger().error((Object)"\u56de\u6eda\u524d\u9a71\u4e8b\u52a1\u5904\u7406\u5668\u65f6\u5f02\u5e38", th);
            }
        }
    }

    @Override
    public TransactionManager.Status getStatus() {
        return this.txObject.get().getStatus();
    }

    private void rollbackFollowingsSilently(int index) {
        for (int i = index; i < this.handlers.length; ++i) {
            try {
                this.handlers[i].doRollback();
                continue;
            }
            catch (Throwable th) {
                this.getLogger().error((Object)"\u56de\u6eda\u540e\u7eed\u4e8b\u52a1\u5904\u7406\u5668\u65f6\u5f02\u5e38", th);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Logger getLogger() {
        if (this.logger == null) {
            TransactionManagerImpl transactionManagerImpl = this;
            synchronized (transactionManagerImpl) {
                if (this.logger == null) {
                    this.logger = ServiceFactory.getService(ILogService.class).getLogger(this.getClass().getName());
                }
            }
        }
        return this.logger;
    }

    @Override
    public void addTransactionHandler(TransactionHandler txHandler) {
        TransactionHandler[] newhandlers = new TransactionHandler[this.handlers.length + 1];
        for (int i = 0; i < this.handlers.length; ++i) {
            newhandlers[i + 1] = this.handlers[i];
        }
        newhandlers[0] = txHandler;
        this.handlers = newhandlers;
    }

    @Override
    public void addTransactionSync(TransactionSync s) {
        this.txObject.get().addSync(s);
    }

    @Override
    public boolean containTransactionSync(TransactionSync s) {
        return this.txObject.get().containsSync(s);
    }

    @Override
    public void removeTransactionSync(TransactionSync s) {
        this.txObject.get().removeSync(s);
    }
}

