/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.ctx.impl;

import net.jplugin.core.config.api.ConfigFactory;
import net.jplugin.core.ctx.api.TransactionHandler;
import net.jplugin.core.ctx.api.TransactionManager;
import net.jplugin.core.ctx.api.TransactionSync;
import net.jplugin.core.ctx.impl.RuleLoggerHelper;
import net.jplugin.core.ctx.impl.TransactionManagerImpl;
import net.jplugin.core.ctx.impl.TxMgrListenerManager;
import net.jplugin.core.kernel.api.PluginEnvirement;

public class TransactionManagerAdaptor
implements TransactionManager {
    private TransactionManager inner = new TransactionManagerImpl();
    public static boolean isLogTx;

    public static void init() {
        isLogTx = "true".equalsIgnoreCase(ConfigFactory.getStringConfig("platform.log-tx-exec"));
        PluginEnvirement.INSTANCE.getStartLogger().log("platform.log-tx-exec value is:" + isLogTx);
    }

    @Override
    public void begin() {
        this.begin("");
    }

    public void begin(String desc) {
        try {
            TxMgrListenerManager.beforeBegin();
            this.inner.begin();
            TxMgrListenerManager.afterBegin();
            if (isLogTx) {
                RuleLoggerHelper.dolog("tx begin success -" + desc);
            }
        }
        catch (Exception e) {
            if (isLogTx) {
                RuleLoggerHelper.dolog("tx begin error. -" + desc, e);
            }
            this.rethrow(e);
        }
    }

    @Override
    public void commit() {
        this.commit("");
    }

    public void commit(String desc) {
        try {
            TxMgrListenerManager.beforeCommit();
            this.inner.commit();
            TxMgrListenerManager.afterCommit(true);
            if (isLogTx) {
                RuleLoggerHelper.dolog("tx commit success. -" + desc);
            }
        }
        catch (Exception e) {
            TxMgrListenerManager.afterCommit(false);
            if (isLogTx) {
                RuleLoggerHelper.dolog("tx commit error. -" + desc, e);
            }
            this.rethrow(e);
        }
    }

    @Override
    public TransactionManager.Status getStatus() {
        return this.inner.getStatus();
    }

    @Override
    public void rollback() {
        this.rollback("");
    }

    public void rollback(String desc) {
        try {
            TxMgrListenerManager.beforeRollback();
            this.inner.rollback();
            if (isLogTx) {
                RuleLoggerHelper.dolog("tx rollback success. -" + desc);
            }
        }
        catch (Exception e) {
            if (isLogTx) {
                RuleLoggerHelper.dolog("tx rollback error. -" + desc, e);
            }
            this.rethrow(e);
        }
    }

    @Override
    public void setRollbackOnly() {
        try {
            this.inner.setRollbackOnly();
            if (isLogTx) {
                RuleLoggerHelper.dolog("tx rollbackonly success. ");
            }
        }
        catch (Exception e) {
            if (isLogTx) {
                RuleLoggerHelper.dolog("tx rollbackonly error. ", e);
            }
            this.rethrow(e);
        }
    }

    private void rethrow(Exception e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    @Override
    public void addTransactionHandler(TransactionHandler txHandler) {
        this.inner.addTransactionHandler(txHandler);
    }

    @Override
    public void addTransactionSync(TransactionSync s) {
        this.inner.addTransactionSync(s);
    }

    @Override
    public boolean containTransactionSync(TransactionSync s) {
        return this.inner.containTransactionSync(s);
    }

    @Override
    public void removeTransactionSync(TransactionSync s) {
        this.inner.removeTransactionSync(s);
    }
}

