/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.ctx.impl;

import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.jplugin.core.ctx.api.Rule;
import net.jplugin.core.ctx.impl.RuleLoggerHelper;

public class RuleInvocationContext {
    private Method method;
    private Object[] args;
    private Rule meta;
    private Date begin;
    private Throwable throwable;
    private Date end;
    ThreadLocal<SimpleDateFormat> local = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd-HH:mm:ss");
            return sdf;
        }
    };

    public void begin(Method aMethod, Object[] aArgs, Rule aMeta) {
        this.method = aMethod;
        this.args = aArgs;
        this.meta = aMeta;
        this.begin = new Date();
    }

    public static void init() {
    }

    public void end(Throwable athrowable) {
        this.throwable = athrowable;
        this.end = new Date();
        if (this.meta.log()) {
            this.doLog();
        }
    }

    private void doLog() {
        StringBuffer sb = new StringBuffer();
        sb.append("-RuleInvoked:").append(this.method.getName()).append(this.meta.actionDesc());
        sb.append(" begin=").append(this.local.get().format(this.begin));
        sb.append(" end=").append(this.local.get().format(this.end));
        sb.append(" dural=").append(this.end.getTime() - this.begin.getTime());
        sb.append(" result=").append(this.throwable == null ? "OK" : "EXCEPTION");
        if (this.meta.logIndexes().length > 0 && this.args != null) {
            sb.append(" param={");
            int[] idxs = this.meta.logIndexes();
            for (int i = 0; i < idxs.length; ++i) {
                int idx = idxs[i];
                if (idx < this.args.length) {
                    sb.append(this.args[idx].toString());
                }
                if (i == idxs.length - 1) continue;
                sb.append(",");
            }
            sb.append("}");
        }
        RuleLoggerHelper.dolog(sb.toString(), this.throwable);
    }
}

