/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.ctx.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.jplugin.core.ctx.api.Rule;
import net.jplugin.core.ctx.api.RuleMetaException;
import net.jplugin.core.ctx.impl.RuleInvocationHandler;

public class RuleInterceptor_old
implements InvocationHandler {
    Class<?> interfaceClass;
    RuleInvocationHandler handler;
    Object oldService;
    MethodMetaLocater locator;

    public RuleInterceptor_old() {
    }

    public RuleInterceptor_old(Class<?> cls) {
        this.interfaceClass = cls;
        this.valid();
        this.locator = new MethodMetaLocater(cls);
    }

    public static Object getProxyInstance(Class clazz, Object oldImpl, RuleInvocationHandler handler) {
        RuleInterceptor_old ei = new RuleInterceptor_old(clazz);
        ei.handler = handler;
        ei.oldService = oldImpl;
        return Proxy.newProxyInstance(oldImpl.getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)ei);
    }

    public void setInterfaceCls(Class cls) {
        this.interfaceClass = cls;
    }

    public void valid() {
        if (!this.interfaceClass.isInterface()) {
            throw new RuleMetaException("cls " + this.interfaceClass + " must be interface!");
        }
    }

    private boolean isTransactionedName(String name) {
        char c2;
        if (name.startsWith("get") || name.startsWith("query") || name.startsWith("list") || name.startsWith("find") || name.startsWith("common")) {
            return false;
        }
        return !name.startsWith("is") || (c2 = name.charAt(2)) < 'A' || c2 > 'Z';
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Rule meta = this.locator.findMeta(method);
        if (meta != null) {
            return this.handler.invoke(proxy, this.oldService, method, args, meta);
        }
        try {
            return method.invoke(this.oldService, args);
        }
        catch (Throwable th) {
            if (th instanceof InvocationTargetException) {
                throw ((InvocationTargetException)th).getTargetException();
            }
            throw th;
        }
    }

    static class MethodMetaLocater {
        HashMap<String, Rule> singleMetaMap = new HashMap();
        HashMap<String, List<MethodParaInfo>> dupMetaMap = new HashMap();

        public String toString() {
            StringBuffer sb = new StringBuffer();
            for (Map.Entry<String, List<MethodParaInfo>> e : this.dupMetaMap.entrySet()) {
                sb.append(e.getKey());
                sb.append("  ");
                sb.append(e.getValue());
            }
            return sb.toString();
        }

        public MethodMetaLocater(Class cls) {
            Rule meta;
            List<Method> dupMethod = this.getDupMethods(cls);
            List<Method> singleMethod = this.getSingleMethods(cls);
            for (Method m : singleMethod) {
                meta = m.getAnnotation(Rule.class);
                this.singleMetaMap.put(m.getName(), m.getAnnotation(Rule.class));
            }
            for (Method m : dupMethod) {
                meta = m.getAnnotation(Rule.class);
                List<MethodParaInfo> list = this.dupMetaMap.get(m.getName());
                if (list == null) {
                    list = new ArrayList<MethodParaInfo>();
                    this.dupMetaMap.put(m.getName(), list);
                }
                list.add(new MethodParaInfo(meta, m.getParameterTypes()));
            }
        }

        public Rule findMeta(Method m) {
            Rule ret = this.singleMetaMap.get(m.getName());
            if (ret != null) {
                return ret;
            }
            List<MethodParaInfo> list = this.dupMetaMap.get(m.getName());
            if (list == null) {
                return null;
            }
            for (MethodParaInfo record : list) {
                if (!this.typeMatch(record.paraTypes, m.getParameterTypes())) continue;
                return record.meta;
            }
            return null;
        }

        private boolean typeMatch(Class[] a1, Class<?>[] a2) {
            if (a1.length != a2.length) {
                return false;
            }
            for (int i = 0; i < a1.length; ++i) {
                if (a1[i] == a2[i]) continue;
                return false;
            }
            return true;
        }

        private List<Method> getSingleMethods(Class cls) {
            List<Method> dupm = this.getDupMethods(cls);
            ArrayList<Method> ret = new ArrayList<Method>();
            for (Method m : cls.getMethods()) {
                if (dupm.contains(m)) continue;
                ret.add(m);
            }
            return ret;
        }

        private List<Method> getDupMethods(Class cls) {
            ArrayList<Method> listRet = new ArrayList<Method>();
            HashSet<String> hs = new HashSet<String>();
            HashSet<String> hsDup = new HashSet<String>();
            for (Method m : cls.getMethods()) {
                if (hs.contains(m.getName())) {
                    hsDup.add(m.getName());
                }
                hs.add(m.getName());
            }
            for (Method m : cls.getMethods()) {
                if (!hsDup.contains(m.getName())) continue;
                listRet.add(m);
            }
            return listRet;
        }

        static class MethodParaInfo {
            Rule meta;
            Class[] paraTypes;

            MethodParaInfo(Rule e, Class[] p) {
                this.meta = e;
                this.paraTypes = p;
            }

            public String toString() {
                StringBuffer sb = new StringBuffer();
                sb.append("{");
                sb.append(this.meta.actionDesc());
                sb.append(" ");
                for (Class c : this.paraTypes) {
                    sb.append(c.getName());
                    sb.append("\t");
                }
                sb.append("}");
                return sb.toString();
            }
        }
    }
}

