/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.ctx.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.jplugin.core.ctx.api.Rule;
import net.jplugin.core.ctx.api.RuleMetaException;
import net.jplugin.core.ctx.impl.DefaultRuleAnnoConfig;
import net.jplugin.core.ctx.impl.RuleInvocationHandler;

public class RuleInterceptor
implements InvocationHandler {
    Class<?> interfaceClass;
    RuleInvocationHandler handler;
    Object oldService;
    MethodMetaLocater locator;

    private RuleInterceptor(Class<?> cls, Object old, RuleInvocationHandler h) {
        this.interfaceClass = cls;
        this.oldService = old;
        this.handler = h;
        this.valid();
        this.locator = new MethodMetaLocater(cls, old.getClass());
    }

    public static Object getProxyInstance(Class clazz, Object oldImpl, RuleInvocationHandler handler) {
        RuleInterceptor ei = new RuleInterceptor(clazz, oldImpl, handler);
        return Proxy.newProxyInstance(oldImpl.getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)ei);
    }

    public void setInterfaceCls(Class cls) {
        this.interfaceClass = cls;
    }

    public void valid() {
        if (!this.interfaceClass.isInterface()) {
            throw new RuleMetaException("cls " + this.interfaceClass + " must be interface!");
        }
        Method[] mds = this.oldService.getClass().getDeclaredMethods();
        if (mds != null) {
            for (Method m : mds) {
                Rule rule = m.getAnnotation(Rule.class);
                if (rule == null) continue;
                Method interfm = null;
                if (!Modifier.isPublic(m.getModifiers())) {
                    throw new RuntimeException("Rule annotation must be used for public methods. " + this.oldService.getClass().getName() + "," + m.getName());
                }
                try {
                    interfm = this.interfaceClass.getMethod(m.getName(), m.getParameterTypes());
                }
                catch (Exception e) {
                    interfm = null;
                }
                if (interfm != null) continue;
                throw new RuntimeException("Rule annotation can't be used for methods not present in rule interface. " + this.oldService.getClass().getName() + "," + m.getName());
            }
        }
    }

    private boolean isTransactionedName(String name) {
        char c2;
        if (name.startsWith("get") || name.startsWith("query") || name.startsWith("list") || name.startsWith("find") || name.startsWith("common")) {
            return false;
        }
        return !name.startsWith("is") || (c2 = name.charAt(2)) < 'A' || c2 > 'Z';
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MethodMetaLocater.MethodParaInfo methodParaInfo = this.locator.findMethodParaInfo(method);
        if (methodParaInfo != null) {
            return this.handler.invoke(proxy, this.oldService, methodParaInfo.method, args, methodParaInfo.meta);
        }
        try {
            return method.invoke(this.oldService, args);
        }
        catch (Throwable th) {
            if (th instanceof InvocationTargetException) {
                throw ((InvocationTargetException)th).getTargetException();
            }
            throw th;
        }
    }

    static class MethodMetaLocater {
        HashMap<String, MethodParaInfo> singleMetaMap = new HashMap();
        HashMap<String, List<MethodParaInfo>> dupMetaMap = new HashMap();

        public String toString() {
            StringBuffer sb = new StringBuffer();
            for (Map.Entry<String, List<MethodParaInfo>> e : this.dupMetaMap.entrySet()) {
                sb.append(e.getKey());
                sb.append("  ");
                sb.append(e.getValue());
            }
            return sb.toString();
        }

        public MethodMetaLocater(Class intfClazz, Class implClazz) {
            List<Method> dupMethod = this.getDupMethods(intfClazz);
            List<Method> singleMethod = this.getSingleMethods(intfClazz);
            for (Method m : singleMethod) {
                MethodParaInfo meta = this.computeMethodParaInfo(m, implClazz);
                this.singleMetaMap.put(m.getName(), meta);
            }
            for (Method m : dupMethod) {
                MethodParaInfo mpi = this.computeMethodParaInfo(m, implClazz);
                if (mpi == null) continue;
                List<MethodParaInfo> list = this.dupMetaMap.get(m.getName());
                if (list == null) {
                    list = new ArrayList<MethodParaInfo>();
                    this.dupMetaMap.put(m.getName(), list);
                }
                list.add(mpi);
            }
        }

        private MethodParaInfo computeMethodParaInfo(Method intfMethod, Class implClazz) {
            Rule defRule;
            Method implMethod;
            try {
                implMethod = implClazz.getMethod(intfMethod.getName(), intfMethod.getParameterTypes());
            }
            catch (Exception e) {
                throw new RuntimeException("The impl class not impl the interface." + intfMethod.getClass().getName() + " " + implClazz.getName());
            }
            MethodParaInfo mpi = MethodParaInfo.tryCreate(implMethod);
            if (mpi == null) {
                mpi = MethodParaInfo.tryCreate(intfMethod);
            }
            if (mpi == null && (defRule = DefaultRuleAnnoConfig.findDefaultRuleAnnotation()) != null) {
                mpi = MethodParaInfo.create(intfMethod, defRule);
            }
            return mpi;
        }

        public MethodParaInfo findMethodParaInfo(Method m) {
            if (this.singleMetaMap.containsKey(m.getName())) {
                return this.singleMetaMap.get(m.getName());
            }
            List<MethodParaInfo> list = this.dupMetaMap.get(m.getName());
            if (list == null) {
                return null;
            }
            for (MethodParaInfo record : list) {
                if (!this.typeMatch(record.paraTypes, m.getParameterTypes())) continue;
                return record;
            }
            return null;
        }

        private boolean typeMatch(Class[] a1, Class<?>[] a2) {
            if (a1.length != a2.length) {
                return false;
            }
            for (int i = 0; i < a1.length; ++i) {
                if (a1[i] == a2[i]) continue;
                return false;
            }
            return true;
        }

        private List<Method> getSingleMethods(Class cls) {
            List<Method> dupm = this.getDupMethods(cls);
            ArrayList<Method> ret = new ArrayList<Method>();
            for (Method m : cls.getMethods()) {
                if (dupm.contains(m)) continue;
                ret.add(m);
            }
            return ret;
        }

        private List<Method> getDupMethods(Class cls) {
            ArrayList<Method> listRet = new ArrayList<Method>();
            HashSet<String> hs = new HashSet<String>();
            HashSet<String> hsDup = new HashSet<String>();
            for (Method m : cls.getMethods()) {
                if (hs.contains(m.getName())) {
                    hsDup.add(m.getName());
                }
                hs.add(m.getName());
            }
            for (Method m : cls.getMethods()) {
                if (!hsDup.contains(m.getName())) continue;
                listRet.add(m);
            }
            return listRet;
        }

        static class MethodParaInfo {
            Method method;
            Rule meta;
            Class[] paraTypes;

            MethodParaInfo() {
            }

            static MethodParaInfo create(Method m, Rule r) {
                MethodParaInfo o = new MethodParaInfo();
                o.meta = r;
                o.paraTypes = m.getParameterTypes();
                o.method = m;
                return o;
            }

            static MethodParaInfo tryCreate(Method m) {
                Rule temp = m.getAnnotation(Rule.class);
                if (temp == null) {
                    return null;
                }
                MethodParaInfo o = new MethodParaInfo();
                o.meta = temp;
                o.paraTypes = m.getParameterTypes();
                o.method = m;
                return o;
            }

            public String toString() {
                StringBuffer sb = new StringBuffer();
                sb.append("{");
                sb.append(this.meta.actionDesc());
                sb.append(" ");
                for (Class c : this.paraTypes) {
                    sb.append(c.getName());
                    sb.append("\t");
                }
                sb.append("}");
                return sb.toString();
            }
        }
    }
}

