/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.ctx.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.jplugin.core.ctx.api.Rule;
import net.jplugin.core.ctx.api.RuleServiceFilterContext;
import net.jplugin.core.ctx.api.TransactionManager;
import net.jplugin.core.ctx.impl.RuleInvocationContext;
import net.jplugin.core.ctx.impl.RuleInvocationHandler;
import net.jplugin.core.ctx.impl.RuleLoggerHelper;
import net.jplugin.core.ctx.impl.TransactionManagerAdaptor;
import net.jplugin.core.kernel.api.PluginFilterManager;
import net.jplugin.core.kernel.api.ctx.ThreadLocalContextManager;
import net.jplugin.core.service.api.ServiceFactory;

public class DefaultRuleInvocationHandler
implements RuleInvocationHandler {
    private static TransactionManagerAdaptor txm;
    private static PluginFilterManager<RuleServiceFilterContext> filterManager;

    public static void init() {
        filterManager.init();
        DefaultRuleInvocationHandler.initTx();
    }

    public static Object invokeWithLog(Object proxyObj, Object oldService, Method method, Object[] args, Rule meta) throws Throwable {
        Throwable throwable = null;
        RuleInvocationContext invokCtx = new RuleInvocationContext();
        invokCtx.begin(method, args, meta);
        try {
            Object object = method.invoke(oldService, args);
            invokCtx.end(throwable);
            return object;
        }
        catch (Throwable th) {
            try {
                throwable = DefaultRuleInvocationHandler.getRethrow(th);
                throw throwable;
            }
            catch (Throwable throwable2) {
                invokCtx.end(throwable);
                throw throwable2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxyObj, Object oldService, Method method, Object[] args, Rule meta) throws Throwable {
        boolean isCreate = false;
        try {
            if (ThreadLocalContextManager.instance.getContext() == null) {
                ThreadLocalContextManager.instance.createContext();
                isCreate = true;
            }
            Object object = filterManager.filter(RuleServiceFilterContext.create(proxyObj, oldService, method, args, meta));
            return object;
        }
        finally {
            if (isCreate) {
                ThreadLocalContextManager.instance.releaseContext();
            }
        }
    }

    public static Object invokeWithTx(Object proxyObj, Object oldService, Method method, Object[] args, Rule meta) throws Throwable {
        DefaultRuleInvocationHandler.initTx();
        Rule.TxType type = meta.methodType();
        if (type == Rule.TxType.REQUIRED) {
            TransactionManager.Status initTxStatus = txm.getStatus();
            if (initTxStatus == TransactionManager.Status.NOTX) {
                txm.begin(method.getName());
            } else if (TransactionManagerAdaptor.isLogTx) {
                RuleLoggerHelper.dolog("tx no need begin -" + method.getName());
            }
            try {
                Object ret = DefaultRuleInvocationHandler.invokeWithLog(proxyObj, oldService, method, args, meta);
                if (initTxStatus == TransactionManager.Status.NOTX) {
                    txm.commit(method.getName());
                } else if (TransactionManagerAdaptor.isLogTx) {
                    RuleLoggerHelper.dolog("tx no need commit -" + method.getName());
                }
                return ret;
            }
            catch (Throwable th) {
                if (initTxStatus == TransactionManager.Status.NOTX) {
                    txm.rollback(method.getName());
                } else if (TransactionManagerAdaptor.isLogTx) {
                    RuleLoggerHelper.dolog("tx no need rollback -" + method.getName());
                }
                throw DefaultRuleInvocationHandler.getRethrow(th);
            }
        }
        return DefaultRuleInvocationHandler.invokeWithLog(proxyObj, oldService, method, args, meta);
    }

    private static Throwable getRethrow(Throwable th) throws Throwable {
        if (th instanceof InvocationTargetException) {
            return ((InvocationTargetException)th).getTargetException();
        }
        return th;
    }

    private static void initTx() {
        if (txm == null) {
            txm = (TransactionManagerAdaptor)ServiceFactory.getService(TransactionManager.class);
        }
    }

    static {
        filterManager = new PluginFilterManager<RuleServiceFilterContext>("EP_RULE_SERVICE_FILTER", (fc, ctx) -> DefaultRuleInvocationHandler.invokeWithTx(ctx.getProxyObject(), ctx.getObject(), ctx.getMethod(), ctx.getArgs(), ctx.getAnnotation()));
    }
}

