/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.ctx.api;

import java.util.Hashtable;
import java.util.Map;
import net.jplugin.core.ctx.api.CtxRuntimeException;
import net.jplugin.core.ctx.api.RuleServiceDefinition;
import net.jplugin.core.ctx.impl.DefaultRuleInvocationHandler;
import net.jplugin.core.ctx.impl.RuleInterceptor;
import net.jplugin.core.kernel.api.Beans;
import net.jplugin.core.kernel.api.PluginEnvirement;

public class RuleServiceFactory {
    private static Hashtable<String, Object> svcMap = new Hashtable();
    private static Map<String, RuleServiceDefinition> serviceDefine = null;

    public static <T> T getRuleService(Class<T> clz) {
        return (T)svcMap.get(clz.getName());
    }

    public static Object getRuleService(String svcname) {
        return svcMap.get(svcname);
    }

    public static <T> T getRuleService(String svcname, Class<T> clz) {
        return (T)svcMap.get(svcname);
    }

    public void init(Map<String, RuleServiceDefinition> defs) {
        serviceDefine = defs;
        for (Map.Entry<String, RuleServiceDefinition> en : defs.entrySet()) {
            Object realImpl;
            RuleServiceDefinition def = en.getValue();
            try {
                def.valid();
                realImpl = def.getImpl().newInstance();
                PluginEnvirement.INSTANCE.resolveRefAnnotation(realImpl);
            }
            catch (Exception e) {
                throw new CtxRuntimeException("Create proxy failed", e);
            }
            Object proxy = RuleInterceptor.getProxyInstance(def.getInterf(), realImpl, new DefaultRuleInvocationHandler());
            Beans.resetValue(def, realImpl);
            svcMap.put(en.getKey(), proxy);
        }
    }

    public static Class<?> getRuleInterface(String blName) {
        return serviceDefine.get(blName).getInterf();
    }
}

