/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.ctx.api;

import java.util.HashMap;
import java.util.Map;
import net.jplugin.common.kits.JsonKit;
import net.jplugin.common.kits.StringKit;
import net.jplugin.core.ctx.api.JsonResult;
import net.jplugin.core.ctx.api.JsonRootMap;

public class JsonResultSerialHelper {
    public static String object2JsonEx(JsonResult jsonResult, int jsonFormat, String jsonp) {
        String result;
        switch (jsonFormat) {
            case 1: {
                result = JsonResultSerialHelper.serialFormat1(jsonResult);
                break;
            }
            case 2: {
                result = JsonResultSerialHelper.serialFormat2(jsonResult);
                break;
            }
            case 3: {
                result = JsonResultSerialHelper.serialFormat3(jsonResult);
                break;
            }
            default: {
                throw new RuntimeException("Error json format indicator:" + jsonFormat);
            }
        }
        if (jsonp != null) {
            return JsonResultSerialHelper.convertToJsonp(result, jsonp);
        }
        return result;
    }

    private static String convertToJsonp(String result, String jsonp) {
        StringBuffer sb = new StringBuffer(jsonp);
        sb.append("(").append(result).append(")");
        return sb.toString();
    }

    private static String serialFormat3(JsonResult jr) {
        return JsonResultSerialHelper.serialFormatCommon(jr, "code", "msg", "success", "data");
    }

    private static String serialFormatCommon(JsonResult jr, String errorNoKey, String errorMsgKey, String successKey, String dataKey) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put(errorNoKey, JsonResultSerialHelper.convertErrNo(jr.code));
        m.put(errorMsgKey, jr.msg);
        m.put(successKey, jr.success);
        Object content = jr.content;
        if (content != null) {
            if (content instanceof Map) {
                Object result = ((Map)content).get("result");
                if (result != null) {
                    if (result instanceof JsonRootMap) {
                        if (((Map)result).containsKey(errorNoKey)) {
                            throw new RuntimeException("Method can't return a map with key:" + errorNoKey);
                        }
                        if (((Map)result).containsKey(errorMsgKey)) {
                            throw new RuntimeException("Method can't return a map with key:" + errorMsgKey);
                        }
                        if (((Map)result).containsKey(successKey)) {
                            throw new RuntimeException("Method can't return a map with key:" + successKey);
                        }
                        m.putAll((Map)result);
                    } else {
                        m.put(dataKey, result);
                    }
                }
            } else {
                throw new RuntimeException("In format2,the content must be Map type now");
            }
        }
        return JsonKit.object2Json(m);
    }

    private static String serialFormat2(JsonResult jr) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("errno", JsonResultSerialHelper.convertErrNo(jr.code));
        m.put("errmsg", jr.msg);
        m.put("success", jr.success);
        Object content = jr.content;
        if (content != null) {
            if (content instanceof Map) {
                Object result = ((Map)content).get("result");
                if (result != null) {
                    if (result instanceof JsonRootMap) {
                        if (((Map)result).containsKey("errno")) {
                            throw new RuntimeException("Method can't return a map with key:errno");
                        }
                        if (((Map)result).containsKey("errmsg")) {
                            throw new RuntimeException("Method can't return a map with key:errmsg");
                        }
                        if (((Map)result).containsKey("success")) {
                            throw new RuntimeException("Method can't return a map with key:success");
                        }
                        m.putAll((Map)result);
                    } else {
                        m.put("data", result);
                    }
                }
            } else {
                throw new RuntimeException("In format2,the content must be Map type now");
            }
        }
        return JsonKit.object2Json(m);
    }

    private static Object convertErrNo(String code) {
        if ("AccessForbidden".equals(code)) {
            return 1024;
        }
        if (code == null || !StringKit.isNumAllowNig(code)) {
            return -1;
        }
        return Integer.parseInt(code);
    }

    private static String serialFormat1(JsonResult jr) {
        return JsonKit.object2Json(jr);
    }
}

