/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.ctx.api;

import java.util.Map;
import net.jplugin.common.kits.JsonKit;

public class HttpServiceResult {
    boolean success;
    String code = "0";
    String msg;
    Object result;

    public boolean isSuccess() {
        return this.success;
    }

    public String getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public Object getResult() {
        return this.result;
    }

    private HttpServiceResult() {
    }

    public static HttpServiceResult create(String json) {
        HttpServiceResult hsr = new HttpServiceResult();
        Map map = JsonKit.json2Map(json);
        if (!map.containsKey("success")) {
            throw new RuntimeException("Error format json,not serialled by JsonResult:" + json);
        }
        if (map.containsKey("code")) {
            return HttpServiceResult.parseFromType1(map, hsr);
        }
        if (map.containsKey("errno")) {
            return HttpServiceResult.parseFromType2(map, hsr);
        }
        throw new RuntimeException("Error format json,not serialled by JsonResult:" + json);
    }

    private static HttpServiceResult parseFromType1(Map map, HttpServiceResult jr) {
        Object result;
        jr.success = (Boolean)map.get("success");
        jr.code = (String)map.get("code");
        jr.msg = (String)map.get("msg");
        Object content = map.get("content");
        if (content != null && (result = ((Map)content).get("result")) != null) {
            jr.result = result;
        }
        return jr;
    }

    private static HttpServiceResult parseFromType2(Map map, HttpServiceResult jr) {
        jr.success = (Boolean)map.get("success");
        jr.code = map.get("errno").toString();
        jr.result = map.get("data");
        jr.msg = (String)map.get("errmsg");
        return jr;
    }
}

