/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.ctx;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jplugin.common.kits.StringKit;
import net.jplugin.common.kits.reso.ResolverKit;
import net.jplugin.core.ctx.api.BindRuleMethodInterceptor;
import net.jplugin.core.ctx.api.BindRuleMethodInterceptorSet;
import net.jplugin.core.ctx.api.BindRuleService;
import net.jplugin.core.ctx.api.BindRuleServiceSet;
import net.jplugin.core.ctx.api.RuleServiceDefinition;
import net.jplugin.core.ctx.impl.filter4clazz.RuleCallFilterDefineBean;
import net.jplugin.core.ctx.kits.PropertyFilterKits;
import net.jplugin.core.kernel.api.AbstractPlugin;
import net.jplugin.core.kernel.api.Beans;
import net.jplugin.core.kernel.api.Extension;
import net.jplugin.core.kernel.api.PluginEnvirement;

public class ExtensionCtxHelper {
    public static void addRuleExtension(AbstractPlugin plugin, String name, Class intf, Class impl) {
        plugin.addExtension(Extension.create("EP_RULE_SERVICE", name, RuleServiceDefinition.class, new String[][]{{"interf", intf.getName()}, {"impl", impl.getName()}}));
    }

    public static void addRuleExtension(AbstractPlugin plugin, Class intf, Class impl) {
        plugin.addExtension(Extension.create("EP_RULE_SERVICE", intf.getName(), RuleServiceDefinition.class, new String[][]{{"interf", intf.getName()}, {"impl", impl.getName()}}));
    }

    public static void addTxMgrListenerExtension(AbstractPlugin plugin, Class impl) {
        plugin.addExtension(Extension.create("EP_TXMGR_LISTENER", impl));
    }

    public static void addRuleServiceFilterExtension(AbstractPlugin plugin, Class impl) {
        plugin.addExtension(Extension.create("EP_RULE_SERVICE_FILTER", impl));
    }

    public static void addRuleMethodFilterExtension(AbstractPlugin plugin, Class impl, String applyTo, Integer sequence) {
        plugin.addExtension(Extension.create("EP_RULE_METHOD_INTERCEPTOR", RuleCallFilterDefineBean.class, new String[][]{{"filterClass", impl.getName()}, {"applyTo", applyTo}, {"priority", sequence.toString()}}));
    }

    public static void autoBindRuleMethodInterceptor(AbstractPlugin p, String pkgPath) {
        for (Class c : p.filterContainedClasses(pkgPath, BindRuleMethodInterceptor.class)) {
            BindRuleMethodInterceptor anno = c.getAnnotation(BindRuleMethodInterceptor.class);
            ExtensionCtxHelper.handleOneRuleMethodFilterBind(p, c, anno);
        }
        for (Class c : p.filterContainedClasses(pkgPath, BindRuleMethodInterceptorSet.class)) {
            Annotation[] annos;
            for (Annotation a : annos = c.getAnnotationsByType(BindRuleMethodInterceptor.class)) {
                ExtensionCtxHelper.handleOneRuleMethodFilterBind(p, c, a);
            }
        }
    }

    private static void handleOneRuleMethodFilterBind(AbstractPlugin p, Class c, Annotation a) {
        BindRuleMethodInterceptor anno = (BindRuleMethodInterceptor)a;
        String applyTo = anno.applyTo();
        applyTo = PropertyFilterKits.filterProperty(applyTo);
        int priority = anno.sequence();
        ExtensionCtxHelper.addRuleMethodFilterExtension(p, c, applyTo, priority);
        PluginEnvirement.INSTANCE.getStartLogger().log("$$$ Auto add extension for RuleMethodFilter: filterClass=" + c.getName() + " applyTo=" + applyTo + " priority=" + priority);
        if (StringKit.isNotNull(anno.id())) {
            Beans.setLastId(anno.id());
        }
    }

    public static void autoBindRuleServiceExtension(AbstractPlugin p, String pkgPath) {
        for (Class c : p.filterContainedClasses(pkgPath, BindRuleService.class)) {
            BindRuleService anno = c.getAnnotation(BindRuleService.class);
            ExtensionCtxHelper.handleOneRuleBind(p, c, anno);
        }
        for (Class c : p.filterContainedClasses(pkgPath, BindRuleServiceSet.class)) {
            Annotation[] annos;
            for (Annotation a : annos = c.getAnnotationsByType(BindRuleService.class)) {
                ExtensionCtxHelper.handleOneRuleBind(p, c, a);
            }
        }
    }

    private static void handleOneRuleBind(AbstractPlugin p, Class c, Annotation a) {
        BindRuleService anno = (BindRuleService)a;
        Class interfaceClazz = anno.interfaceClass();
        if (interfaceClazz.getName().equals(BindRuleService.DefaultInterface.class.getName())) {
            interfaceClazz = ExtensionCtxHelper.computeInterfaceCls(c);
        }
        if (StringKit.isNull(anno.name())) {
            ExtensionCtxHelper.addRuleExtension(p, interfaceClazz, c);
            PluginEnvirement.INSTANCE.getStartLogger().log("$$$ Auto add extension for rule service: interface=" + interfaceClazz.getName() + " impl=" + c.getName());
        } else {
            ExtensionCtxHelper.addRuleExtension(p, anno.name(), interfaceClazz, c);
            PluginEnvirement.INSTANCE.getStartLogger().log("$$$ Auto add extension for rule service: interface=" + interfaceClazz.getName() + " impl=" + c.getName());
        }
        if (StringKit.isNotNull(anno.id())) {
            Beans.setLastId(anno.id());
        }
    }

    private static Class computeInterfaceCls(Class impClazz) {
        Class<?>[] clazzs = impClazz.getInterfaces();
        if (clazzs.length == 0) {
            throw new RuntimeException("Class must implement a interface, so as to be defined as a RuleService impl. " + impClazz.getName());
        }
        if (clazzs.length > 1) {
            throw new RuntimeException("Class with multiple interfaces, must specify one interface in annotation. " + impClazz.getName());
        }
        return clazzs[0];
    }

    @Deprecated
    public static void autoAddRuleServiceExtension(AbstractPlugin p, String apiPkgPath, String implPkgPath) {
        String pkg = p.getClass().getPackage().getName() + apiPkgPath;
        ResolverKit kit = new ResolverKit();
        kit.find(pkg, c -> c.isInterface());
        Set apiClazzes = kit.getClasses();
        HashMap mappings = new HashMap();
        for (Class clazz : apiClazzes) {
            mappings.put(clazz, new ArrayList());
        }
        pkg = p.getClass().getPackage().getName() + implPkgPath;
        kit = new ResolverKit();
        kit.find(pkg, c -> {
            for (Map.Entry en : mappings.entrySet()) {
                if (!((Class)en.getKey()).isAssignableFrom(c) || c.isInterface()) continue;
                ((List)en.getValue()).add(c);
            }
            return false;
        });
        for (Map.Entry entry : mappings.entrySet()) {
            if (((List)entry.getValue()).size() == 1) {
                ExtensionCtxHelper.addRuleExtension(p, (Class)entry.getKey(), (Class)((List)entry.getValue()).get(0));
                PluginEnvirement.INSTANCE.getStartLogger().log("$$$ Auto add extension for rule service: interface=" + ((Class)entry.getKey()).getName() + " impl=" + ((Class)((List)entry.getValue()).get(0)).getName());
                continue;
            }
            if (((List)entry.getValue()).size() == 0) continue;
            PluginEnvirement.INSTANCE.getStartLogger().log("$$$ Auto add extension for rule service failed , Multiple impl found for interface " + ((Class)entry.getKey()).getName());
        }
    }
}

