/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.common.kits.http.mock;

import java.util.Map;
import net.jplugin.common.kits.JsonKit;
import net.jplugin.common.kits.http.mock.HttpServletRequestMock;
import net.jplugin.common.kits.http.mock.HttpServletResponseMock;
import net.jplugin.common.kits.http.mock.IHttpService;

public class HttpMock {
    public HttpServletRequestMock request = new HttpServletRequestMock();
    public HttpServletResponseMock response = new HttpServletResponseMock();
    public static IHttpService servletSvc;

    public HttpMock() {
        this.request.setResponse(this.response);
    }

    public static HttpMock create() {
        return new HttpMock();
    }

    public static HttpMock createFromUrl(String url) {
        HttpMock mock = new HttpMock();
        mock.request.initFromUrl(url);
        return mock;
    }

    public HttpMock para(String key, String value) {
        this.request.setPara(key, value);
        return this;
    }

    public HttpMock servletPath(String path) {
        this.request.setServletPath(path);
        return this;
    }

    public String invoke() {
        DummyHttpThread thread = new DummyHttpThread();
        thread.start();
        while (!thread.finished) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.response.getResult();
    }

    public Map invokeForJson() {
        return JsonKit.json2Map(this.invoke());
    }

    public static void initServletSvc(IHttpService s) {
        servletSvc = s;
    }

    public class DummyHttpThread
    extends Thread {
        boolean finished = false;

        @Override
        public void run() {
            servletSvc.dohttp(HttpMock.this.request, HttpMock.this.response);
            this.finished = true;
        }
    }
}

