/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.common.kits.http;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import net.jplugin.common.kits.AssertKit;
import net.jplugin.common.kits.JsonKit;
import net.jplugin.common.kits.StringKit;
import net.jplugin.common.kits.client.ClientInvocationManager;
import net.jplugin.common.kits.client.InvocationParam;
import net.jplugin.common.kits.filter.FilterChain;
import net.jplugin.common.kits.filter.FilterManager;
import net.jplugin.common.kits.filter.IFilter;
import net.jplugin.common.kits.http.ContentKit;
import net.jplugin.common.kits.http.HttpStatusException;
import net.jplugin.common.kits.http.filter.HttpClientFilterContext;
import net.jplugin.common.kits.http.mock.HttpMock;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public final class HttpKit {
    private static final int DEFAULT_SOCKET_BUFFER_SIZE = 8192;
    private static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    private static final String ENCODING_GZIP = "gzip";
    private static final String MAX_CONNECTIONS = "maxConnections";
    private static final String MAX_CONNECTIONS_PER_ROUTE = "maxConnectionsPerRoute";
    private static final String CONNECT_TIME_OUT = "connectTimeout";
    private static final String CONNECTION_REQUEST_TIME_OUT = "connectionRequestTimeout";
    private static final String SOCKET_TIME_OUT = "socketTimeout";
    private static String maxConnections = "200";
    private static String maxConnectionsPerRoute = "20";
    private static String socketTimeout = "6";
    private static int maxRetries = 5;
    private static int httpThreadCount = 3;
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static boolean unitTesting = false;
    private static HttpClientBuilder clientBuilder;
    private static FilterManager<HttpClientFilterContext> filterManager;
    private static Map<String, String> configMap;
    private static CloseableHttpClient httpClient;
    public static ConnectionKeepAliveStrategy myStrategy;

    public static boolean isUnitTesting() {
        return unitTesting;
    }

    public static void setUnitTesting(boolean b) {
        unitTesting = b;
    }

    public static void reInitHttpClientBuilder(Map<String, String> appCenterConfigMap) {
        configMap.putAll(appCenterConfigMap);
        clientBuilder = HttpKit.initHttpClientBuilder();
    }

    private static HttpClientBuilder initHttpClientBuilder() {
        int _maxConnections = Integer.parseInt(configMap.get(MAX_CONNECTIONS));
        int _maxConnectionsPerRoute = Integer.parseInt(configMap.get(MAX_CONNECTIONS_PER_ROUTE));
        int _connectTimeOut = Integer.parseInt(configMap.get(CONNECT_TIME_OUT));
        int _connectionRequestTimeout = Integer.parseInt(configMap.get(CONNECTION_REQUEST_TIME_OUT));
        int _socketTimeout = Integer.parseInt(configMap.get(SOCKET_TIME_OUT));
        HttpClientBuilder builder = HttpClientBuilder.create();
        try {
            RequestConfig config = RequestConfig.custom().setConnectTimeout(_connectTimeOut * 1000).setConnectionRequestTimeout(_connectionRequestTimeout * 1000).setSocketTimeout(_socketTimeout * 1000).build();
            builder.setDefaultRequestConfig(config);
            SocketConfig socketConfig = SocketConfig.custom().setTcpNoDelay(true).setSoKeepAlive(true).build();
            ConnectionConfig connectionConfig = ConnectionConfig.custom().setCharset(UTF_8).setBufferSize(8192).build();
            HttpRequestRetryHandler httpRequestRetryHandler = new HttpRequestRetryHandler(){

                public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                    if (executionCount >= maxRetries) {
                        return false;
                    }
                    if (exception instanceof NoHttpResponseException) {
                        return true;
                    }
                    if (exception instanceof SSLHandshakeException) {
                        return false;
                    }
                    if (exception instanceof ConnectTimeoutException) {
                        return false;
                    }
                    if (exception instanceof InterruptedIOException) {
                        return false;
                    }
                    if (exception instanceof UnknownHostException) {
                        return false;
                    }
                    if (exception instanceof SSLException) {
                        return false;
                    }
                    HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
                    HttpRequest request = clientContext.getRequest();
                    return !(request instanceof HttpEntityEnclosingRequest);
                }
            };
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null, null);
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    return true;
                }
            }).build();
            Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build();
            PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(registry);
            cm.setMaxTotal(_maxConnections);
            cm.setDefaultMaxPerRoute(_maxConnectionsPerRoute);
            cm.setDefaultSocketConfig(socketConfig);
            cm.setDefaultConnectionConfig(connectionConfig);
            builder.setConnectionManager((HttpClientConnectionManager)cm);
            builder.setRetryHandler(httpRequestRetryHandler);
            builder.setKeepAliveStrategy(myStrategy);
            return builder;
        }
        catch (Exception e) {
            e.printStackTrace();
            return builder;
        }
    }

    private static CloseableHttpClient createHttpClient() {
        return clientBuilder.build();
    }

    @Deprecated
    public static String _post(String url, Map<String, Object> datas, Map<String, String> extHeaders) throws IOException, HttpStatusException {
        return HttpKit._handleWithEntity(HttpClientFilterContext.Method.POST, url, datas, extHeaders);
    }

    public static String _handleWithEntity(HttpClientFilterContext.Method method, String url, Map<String, Object> datas, Map<String, String> extHeaders) throws IOException, HttpStatusException {
        if (HttpKit.isUnitTesting() && (url.startsWith("http://localhost") || url.startsWith("https://localhost"))) {
            return HttpKit.executeDummy(url, datas, extHeaders);
        }
        HttpEntityEnclosingRequestBase httpPost = (HttpEntityEnclosingRequestBase)HttpKit.createRequest(method, url);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        Set<Map.Entry<String, Object>> temps = datas.entrySet();
        for (Map.Entry<String, Object> entry : temps) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) {
                value = "";
            }
            if (key == null) continue;
            params.add(new BasicNameValuePair(key, JsonKit.object2JsonEx(value)));
        }
        if (datas != null && extHeaders != null && HttpKit.isJsonFormat(extHeaders)) {
            httpPost.setEntity((HttpEntity)new StringEntity(JsonKit.object2JsonEx(datas), UTF_8));
        } else {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, UTF_8));
        }
        if (extHeaders != null) {
            for (Map.Entry<String, Object> entry : extHeaders.entrySet()) {
                httpPost.setHeader(entry.getKey(), (String)entry.getValue());
            }
        }
        HttpKit.useInvokeParam((HttpRequestBase)httpPost);
        return HttpKit.handleResponse(httpClient, (HttpRequestBase)httpPost);
    }

    private static boolean isJsonFormat(Map<String, String> extHeaders) {
        return ContentKit.isApplicationJson(extHeaders.get("Content-Type"));
    }

    private static void useInvokeParam(HttpRequestBase httpReqBase) {
        InvocationParam invokeParam = ClientInvocationManager.INSTANCE.getAndClearParam();
        if (invokeParam != null) {
            RequestConfig.Builder configBuilder = RequestConfig.custom();
            int soTimeout = invokeParam.getServiceTimeOut();
            if (soTimeout != 0) {
                configBuilder.setSocketTimeout(soTimeout);
                configBuilder.setConnectionRequestTimeout(soTimeout);
                configBuilder.setConnectTimeout(soTimeout);
            }
            httpReqBase.setConfig(configBuilder.build());
        }
    }

    private static String executeDummy(String url, Map<String, Object> datas, Map<String, String> extHeaders) {
        if (url.indexOf(63) >= 0) {
            throw new RuntimeException("not impl get mode");
        }
        HttpMock mock = HttpMock.createFromUrl(url);
        if (datas != null) {
            mock.request.putAllParameter(datas, extHeaders);
        }
        return mock.invoke();
    }

    @Deprecated
    public static String _get(String url, Map<String, String> extHeaders) throws IOException, HttpStatusException {
        return HttpKit._handleWithoutEntity(HttpClientFilterContext.Method.GET, url, extHeaders);
    }

    public static String _handleWithoutEntity(HttpClientFilterContext.Method method, String url, Map<String, String> extHeaders) throws IOException, HttpStatusException {
        if (HttpKit.isUnitTesting() && (url.startsWith("http://localhost") || url.startsWith("https://localhost"))) {
            return HttpKit.executeDummy(url, null, extHeaders);
        }
        HttpRequestBase httpGet = HttpKit.createRequest(method, url);
        if (extHeaders != null) {
            for (Map.Entry<String, String> en : extHeaders.entrySet()) {
                httpGet.setHeader(en.getKey(), en.getValue());
            }
        }
        HttpKit.useInvokeParam(httpGet);
        return HttpKit.handleResponse(httpClient, httpGet);
    }

    private static HttpRequestBase createRequest(HttpClientFilterContext.Method method, String url) {
        switch (method) {
            case POST: {
                return new HttpPost(url);
            }
            case GET: {
                return new HttpGet(url);
            }
            case PUT: {
                return new HttpPut(url);
            }
            case DELETE: {
                return new HttpGet(url);
            }
        }
        throw new RuntimeException("not support method:" + (Object)((Object)method));
    }

    public static String handleResponse(CloseableHttpClient client, HttpRequestBase request) throws IOException, HttpStatusException {
        String responseText;
        block7: {
            responseText = "";
            if (request.getHeaders("Connection") == null) {
                request.setHeader("Connection", "close");
            }
            try {
                CloseableHttpResponse response = client.execute((HttpUriRequest)request);
                if (response == null) break block7;
                int code = response.getStatusLine().getStatusCode();
                if (code >= 200 && code <= 206) {
                    responseText = EntityUtils.toString((HttpEntity)response.getEntity());
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    request.reset();
                    break block7;
                }
                request.abort();
                throw new HttpStatusException("Status Error:" + code);
            }
            catch (Exception ex) {
                if (!request.isAborted()) {
                    request.abort();
                }
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                if (ex instanceof HttpStatusException) {
                    throw (HttpStatusException)ex;
                }
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        return responseText;
    }

    public static String encodeParam(String param) {
        try {
            return URLEncoder.encode(param, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws IOException, HttpStatusException {
        String s = HttpKit.get("http://192.133.212.11/32234");
        System.out.println(s);
    }

    public static String post(String url, Map<String, Object> params) throws IOException, HttpStatusException {
        HttpClientFilterContext ctx = new HttpClientFilterContext(HttpClientFilterContext.Method.POST, url, params);
        return (String)filterManager.filter(ctx);
    }

    public static String postWithHeader(String url, Map<String, Object> params, Map<String, String> headers) throws IOException, HttpStatusException {
        HttpClientFilterContext ctx = new HttpClientFilterContext(HttpClientFilterContext.Method.POST, url, params, headers);
        return (String)filterManager.filter(ctx);
    }

    public static String postJsonWithHeader(String url, Map<String, Object> params, Map<String, String> headers) throws IOException, HttpStatusException {
        String contentTypeValue;
        HashMap<String, String> headMap = new HashMap<String, String>();
        if (headers != null) {
            headMap.putAll(headers);
        }
        if (StringKit.isNull(contentTypeValue = (String)headMap.get("Content-Type"))) {
            headMap.put("Content-Type", "application/json");
        } else if (!ContentKit.isApplicationJson(contentTypeValue)) {
            throw new RuntimeException("Content-Type is set,but not json type!");
        }
        return HttpKit.postWithHeader(url, params, headMap);
    }

    public static String postJsonWithHeader(String url, String json, Map<String, String> headers) throws IOException, HttpStatusException {
        if (!json.startsWith("{")) {
            throw new RuntimeException("json must start with '{'");
        }
        return HttpKit.postJsonWithHeader(url, JsonKit.json2Map(json), headers);
    }

    public static String postJson(String url, String json) throws IOException, HttpStatusException {
        return HttpKit.postJsonWithHeader(url, json, null);
    }

    public static String postJson(String url, Map json) throws IOException, HttpStatusException {
        return HttpKit.postJsonWithHeader(url, json, null);
    }

    public static String putWithHeader(String url, Map<String, Object> params, Map<String, String> headers) throws IOException, HttpStatusException {
        HttpClientFilterContext ctx = new HttpClientFilterContext(HttpClientFilterContext.Method.PUT, url, params, headers);
        return (String)filterManager.filter(ctx);
    }

    public static String get(String url) throws IOException, HttpStatusException {
        HttpClientFilterContext ctx = new HttpClientFilterContext(HttpClientFilterContext.Method.GET, url, null);
        return (String)filterManager.filter(ctx);
    }

    public static String getWithHeader(String url, Map<String, String> headers) throws IOException, HttpStatusException {
        HttpClientFilterContext ctx = new HttpClientFilterContext(HttpClientFilterContext.Method.GET, url, null, headers);
        return (String)filterManager.filter(ctx);
    }

    public static String deleteWithHeader(String url, Map<String, String> headers) throws IOException, HttpStatusException {
        HttpClientFilterContext ctx = new HttpClientFilterContext(HttpClientFilterContext.Method.DELETE, url, null, headers);
        return (String)filterManager.filter(ctx);
    }

    public static void _setHttpFilterManager(FilterManager<HttpClientFilterContext> fm) {
        filterManager = fm;
    }

    static {
        filterManager = new FilterManager();
        configMap = new ConcurrentHashMap<String, String>();
        filterManager.addFilter(new IFilter<HttpClientFilterContext>(){

            @Override
            public Object filter(FilterChain fc, HttpClientFilterContext ctx) throws Throwable {
                return HttpExecution.execute(ctx);
            }
        });
        configMap.put(MAX_CONNECTIONS, maxConnections);
        configMap.put(MAX_CONNECTIONS_PER_ROUTE, maxConnectionsPerRoute);
        configMap.put(CONNECT_TIME_OUT, socketTimeout);
        configMap.put(CONNECTION_REQUEST_TIME_OUT, socketTimeout);
        configMap.put(SOCKET_TIME_OUT, socketTimeout);
        clientBuilder = HttpKit.initHttpClientBuilder();
        httpClient = HttpKit.createHttpClient();
        myStrategy = (response, context) -> {
            BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
            while (it.hasNext()) {
                HeaderElement he = it.nextElement();
                String param = he.getName();
                String value = he.getValue();
                if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                return Long.parseLong(value) * 1000L;
            }
            return 20000L;
        };
    }

    public static class HttpExecution {
        public static Object execute(HttpClientFilterContext ctx) throws Throwable {
            HttpExecution.validate(ctx);
            HttpClientFilterContext.Method method = ctx.getMethod();
            if (method == HttpClientFilterContext.Method.POST || method == HttpClientFilterContext.Method.PUT) {
                return HttpKit._handleWithEntity(method, ctx.getUrl(), ctx.getParams(), ctx.getHeaders());
            }
            if (method == HttpClientFilterContext.Method.GET || method == HttpClientFilterContext.Method.DELETE) {
                return HttpKit._handleWithoutEntity(method, ctx.getUrl(), ctx.getHeaders());
            }
            throw new RuntimeException("not supported http method:" + (Object)((Object)method));
        }

        private static void validate(HttpClientFilterContext ctx) {
            HttpClientFilterContext.Method m = ctx.getMethod();
            Map<String, Object> params = ctx.getParams();
            AssertKit.assertNotNull((Object)m, "http method");
            AssertKit.assertTrue(m == HttpClientFilterContext.Method.POST || m == HttpClientFilterContext.Method.PUT || (m == HttpClientFilterContext.Method.GET || m == HttpClientFilterContext.Method.DELETE) && (params == null || params.isEmpty()));
        }
    }
}

