/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.common.kits;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReflactKit {
    public static Object invoke(Object o, String methodName, Object[] args) {
        Method[] methods;
        for (Method m : methods = o.getClass().getMethods()) {
            if (!methodName.equals(m.getName())) continue;
            try {
                return m.invoke(o, args);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Can't find the method:" + methodName + " in cls " + o.getClass().getName());
    }

    public static Object invoke(Class type, String methodname, Class[] argtypes, Object[] args) {
        return ReflactKit.invoke(type, null, methodname, argtypes, args);
    }

    public static Object invoke(Class type, Object obj, String methodname, Class[] argtypes, Object[] args) {
        try {
            Method method = type.getMethod(methodname, argtypes);
            return method.invoke(obj, args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isTypeOf(Class child, Class parent) {
        return parent.isAssignableFrom(child);
    }

    public static Set<String> getProperties(Class<?> c) {
        return ReflactKit.getPropertiesAndType(c).keySet();
    }

    public static Map<String, Class<?>> getDeclaredPropertiesAndType(Class<?> c) {
        return ReflactKit.getPropertiesAndType(c.getDeclaredMethods());
    }

    public static Map<String, Class<?>> getPropertiesAndType(Class<?> c) {
        return ReflactKit.getPropertiesAndType(c.getMethods());
    }

    private static Map<String, Class<?>> getPropertiesAndType(Method[] marr) {
        Method[] methods = marr;
        HashMap ret = new HashMap();
        for (Method m : methods) {
            int modf;
            String methodName = m.getName();
            if (methodName.length() <= 3 || ((modf = m.getModifiers()) & 1) == 0 || (modf & 8) != 0 || m.getDeclaringClass() == Object.class || !methodName.startsWith("get")) continue;
            String property = methodName.substring(3);
            property = property.substring(0, 1).toLowerCase() + property.substring(1);
            ret.put(property, m.getReturnType());
        }
        return ret;
    }

    public static String getShortName(Class c) {
        String nm = c.getName();
        int pos = nm.lastIndexOf(46);
        if (pos < 0) {
            return nm;
        }
        return nm.substring(pos + 1);
    }

    public static Method[] getMethods(Class<? extends Object> clazz, String operation) {
        Method[] methods;
        ArrayList<Method> ret = new ArrayList<Method>(1);
        for (Method m : methods = clazz.getMethods()) {
            if (!m.getName().equals(operation)) continue;
            ret.add(m);
        }
        Method[] arr = new Method[ret.size()];
        return ret.toArray(arr);
    }

    public static void setPropertyFromString(Object o, String key, String value) {
        Map<String, Class<?>> meta = ReflactKit.getPropertiesAndType(o.getClass());
        Class<?> type = meta.get(key);
        if (type == null) {
            throw new RuntimeException("Can't find property :" + key + " in " + o.getClass().getName());
        }
        Object val = ReflactKit.changeTypeFromString(type, value);
        ReflactKit.setProperty(o, key, val);
    }

    private static Object changeTypeFromString(Class type, String value) {
        if (type == String.class) {
            return value;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return Integer.parseInt(value);
        }
        if (type == Long.TYPE || type == Long.class) {
            return Long.parseLong(value);
        }
        if (type == Double.TYPE || type == Float.TYPE || type == Float.class) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return Boolean.parseBoolean(value);
        }
        if (type == Character.class || type == Character.TYPE) {
            if (value.length() != 1) {
                throw new RuntimeException("error char value:" + value);
            }
            return Character.valueOf(value.charAt(0));
        }
        if (type == Class.class) {
            try {
                return Class.forName(value);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (type.isEnum()) {
            return ReflactKit.invoke(type, "valueOf", new Class[]{String.class}, new Object[]{value});
        }
        throw new RuntimeException("Primate type not support:" + type.getName());
    }

    public static void setProperty(Object o, String key, Object val) {
        String method = "set" + key.substring(0, 1).toUpperCase() + key.substring(1);
        ReflactKit.invoke(o, method, new Object[]{val});
    }

    public static Method findSingeMethodExactly(Class c, String methodName) {
        Method ret = null;
        for (Method m : c.getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            if (ret == null) {
                ret = m;
                if (!Object.class.equals(m.getDeclaringClass())) continue;
                throw new RuntimeException("Can't locate Object class methods :" + methodName);
            }
            throw new RuntimeException("find a second method for name:" + methodName + " in " + c.getName());
        }
        return ret;
    }

    public static Method getGetterMethod(Class c, String attr) throws SecurityException, NoSuchMethodException {
        String pName = "get" + Character.toUpperCase(attr.charAt(0)) + attr.substring(1);
        return c.getMethod(pName, new Class[0]);
    }

    public static List<Field> getAllFields(Object obj) {
        ArrayList<Field> l = new ArrayList<Field>();
        for (Class<?> clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field f : clazz.getDeclaredFields()) {
                l.add(f);
            }
        }
        return l;
    }

    public static Object getFieldValueForce(Field field, Object o) {
        try {
            field.setAccessible(true);
            return field.get(o);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Get field value error:" + field.getName() + " Obj:" + o.getClass().getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Get field value error:" + field.getName() + " Obj:" + o.getClass().getName(), e);
        }
    }

    public static void setFieldValueForce(Field field, Object o, Object v) {
        try {
            field.setAccessible(true);
            field.set(o, v);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Set field value error:" + field.getName() + " Obj:" + o.getClass().getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Set field value error:" + field.getName() + " Obj:" + o.getClass().getName(), e);
        }
    }

    public static Set<String> getMethodNamesExceptObject(Class c) {
        Method[] methods = c.getMethods();
        HashSet<String> names = new HashSet<String>();
        for (Method m : methods) {
            if (Object.class.equals(m.getDeclaringClass())) continue;
            names.add(m.getName());
        }
        return names;
    }

    public static void main(String[] arg) {
        System.out.println(ReflactKit.getMethodNamesExceptObject(ReflactKit.class));
    }
}

