/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.common.kits;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class PritiveKits {
    private static Map<Class, Transformer> transformerMap = new HashMap<Class, Transformer>();

    public static boolean support(Class clz) {
        return PritiveKits.getTransformer(clz) != null;
    }

    public static Transformer getTransformer(Class clz) {
        if (clz.isEnum()) {
            return transformerMap.get(Enum.class);
        }
        return transformerMap.get(clz);
    }

    public static void main(String[] args) {
        String s = "aaa";
        int i = 1;
        Integer ii = 1;
        long l = 1L;
        Long ll = 1L;
        Double d = 1.1;
        Float f = Float.valueOf(1.0f);
        float ff = 1.0f;
        Date dd = new Date();
        EE e = EE.A;
        Object[] arr = new Object[]{s, i, i, l, ll, d, f, Float.valueOf(ff), dd, e};
        for (int iii = 0; iii < arr.length; ++iii) {
            Class<?> cls = arr[iii].getClass();
            Object obj = arr[iii];
            Transformer trans = PritiveKits.getTransformer(cls);
            System.out.println(trans.convertToString(trans.fromString(cls, trans.convertToString(obj))));
        }
    }

    static {
        transformerMap.put(Integer.class, new IntegerTrans());
        transformerMap.put(Integer.TYPE, new IntegerTrans());
        transformerMap.put(Long.class, new LongTrans());
        transformerMap.put(Long.TYPE, new LongTrans());
        transformerMap.put(Double.class, new DoubleTrans());
        transformerMap.put(Double.TYPE, new DoubleTrans());
        transformerMap.put(Float.class, new FloatTrans());
        transformerMap.put(Float.TYPE, new FloatTrans());
        transformerMap.put(Date.class, new DateTrans());
        transformerMap.put(String.class, new StringTrans());
        transformerMap.put(Enum.class, new EnumTrans());
        transformerMap.put(Boolean.class, new BooleanTrans());
        transformerMap.put(Boolean.TYPE, new BooleanTrans());
    }

    static enum EE {
        A,
        B,
        C;

    }

    public static class EnumTrans
    extends Transformer {
        @Override
        public String convertToString(Object obj) {
            return obj.toString();
        }

        @Override
        public Object fromString(Class t, String s) {
            return Enum.valueOf(t, s);
        }
    }

    public static class BooleanTrans
    extends Transformer {
        @Override
        public String convertToString(Object obj) {
            if (((Boolean)obj).booleanValue()) {
                return "true";
            }
            return "false";
        }

        @Override
        public Object fromString(Class t, String s) {
            if ("true".equals(s)) {
                return true;
            }
            return false;
        }
    }

    public static class DateTrans
    extends Transformer {
        @Override
        public String convertToString(Object obj) {
            return String.valueOf(((Date)obj).getTime());
        }

        @Override
        public Object fromString(Class t, String s) {
            return new Date(Long.parseLong(s));
        }
    }

    public static class FloatTrans
    extends Transformer {
        @Override
        public String convertToString(Object obj) {
            return obj.toString();
        }

        @Override
        public Object fromString(Class t, String s) {
            return Float.valueOf(Float.parseFloat(s));
        }
    }

    public static class DoubleTrans
    extends Transformer {
        @Override
        public String convertToString(Object obj) {
            return obj.toString();
        }

        @Override
        public Object fromString(Class t, String s) {
            return Double.parseDouble(s);
        }
    }

    public static class LongTrans
    extends Transformer {
        @Override
        public String convertToString(Object obj) {
            return obj.toString();
        }

        @Override
        public Object fromString(Class t, String s) {
            return Long.parseLong(s);
        }
    }

    public static class IntegerTrans
    extends Transformer {
        @Override
        public String convertToString(Object obj) {
            return obj.toString();
        }

        @Override
        public Object fromString(Class t, String s) {
            return Integer.parseInt(s);
        }
    }

    public static class StringTrans
    extends Transformer {
        @Override
        public String convertToString(Object obj) {
            return (String)obj;
        }

        @Override
        public Object fromString(Class t, String s) {
            return s;
        }
    }

    public static class Transformer {
        public String convertToString(Object obj) {
            return null;
        }

        public Object fromString(Class t, String s) {
            return null;
        }
    }
}

