/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.common.kits;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;

public class CalenderKit {
    private static final String date_pattern_short = "yyMMdd";
    private static final String month_pattern_short = "yyMM";
    public static String split_pattern = "yyyy-MM-dd HH:mm:ss";
    public static String date_pattern = "yyyyMMdd";
    public static String time_pattern = "yyyyMMddHHmmss";

    public static LocalDateTime convertDate2LocalDateTime(Date d) {
        Instant inst = Instant.ofEpochMilli(d.getTime());
        return LocalDateTime.ofInstant(inst, ZoneId.systemDefault());
    }

    public static LocalDate convertDate2LocalDate(Date d) {
        Instant inst = Instant.ofEpochMilli(d.getTime());
        return LocalDateTime.ofInstant(inst, ZoneId.systemDefault()).toLocalDate();
    }

    public static Date convertLocalDate2Date(LocalDate d) {
        Instant inst = d.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
        return Date.from(inst);
    }

    public static Date convertLocalDateTime2Date(LocalDateTime d) {
        Instant inst = d.atZone(ZoneId.systemDefault()).toInstant();
        return Date.from(inst);
    }

    public static String getTimeString(long timeLong) {
        return CalenderKit.getFormatedTimeString(timeLong, time_pattern);
    }

    public static Date getTimeFromString(String timeString) {
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern(time_pattern);
        try {
            return sdf.parse(timeString);
        }
        catch (ParseException e) {
            throw new RuntimeException("parse error:" + timeString);
        }
    }

    public static Date getTimeFromString(String timeString, String patten) {
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern(patten);
        try {
            return sdf.parse(timeString);
        }
        catch (ParseException e) {
            throw new RuntimeException("parse error:" + timeString);
        }
    }

    public static String getDateString(long timeLong) {
        return CalenderKit.getFormatedTimeString(timeLong, date_pattern);
    }

    public static String getShortDateString(long timeLong) {
        return CalenderKit.getFormatedTimeString(timeLong, date_pattern_short);
    }

    public static String getShortMonthString(long timeLong) {
        return CalenderKit.getFormatedTimeString(timeLong, month_pattern_short);
    }

    public static Date getDateFromString(String dateString) {
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern(date_pattern);
        try {
            return sdf.parse(dateString);
        }
        catch (ParseException e) {
            throw new RuntimeException("parse error:" + dateString);
        }
    }

    public static String getFormatedTimeString(long timeLong, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern(pattern);
        return sdf.format(new Date(timeLong));
    }

    public static String getCurrentTimeString() {
        return CalenderKit.getTimeString(System.currentTimeMillis());
    }

    public static String getCurrentDateString() {
        Date dt = new Date();
        return CalenderKit.getFormatedTimeString(dt.getTime(), date_pattern);
    }

    public static String getSpitTimeString(long timeLong) {
        return CalenderKit.getFormatedTimeString(timeLong, split_pattern);
    }

    public static long getCurrentTime() {
        return new Date().getTime();
    }

    public static long getTime(String timeString) throws RuntimeException {
        Date dt;
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern("yyyyMMddHHmmss");
        try {
            dt = sdf.parse(timeString);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return dt.getTime();
    }

    public static String getTimeDescription(long time) {
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern("yyyy\u5e74MM\u6708dd\u65e5HH:mm:ss");
        return sdf.format(new Date(time));
    }

    public static Date addMillisecond(Date dt, int millisecond) {
        return CalenderKit.addSecond(dt, (long)millisecond);
    }

    public static Date addMillisecond(Date dt, long millisecond) {
        dt.setTime(dt.getTime() + millisecond);
        return dt;
    }

    public static Date addSecond(Date dt, int second) {
        return CalenderKit.addSecond(dt, (long)second);
    }

    public static Date addSecond(Date dt, float second) {
        return CalenderKit.addSecond(dt, (double)second);
    }

    public static Date addSecond(Date dt, long second) {
        return CalenderKit.addMillisecond(dt, 1000L * second);
    }

    public static Date addSecond(Date dt, double second) {
        Double millisecond = new Double(1000.0 * second);
        return CalenderKit.addMillisecond(dt, millisecond.longValue());
    }

    public static Date addMinute(Date dt, int minute) {
        return CalenderKit.addMinute(dt, (long)minute);
    }

    public static Date addMinute(Date dt, float minute) {
        return CalenderKit.addMinute(dt, (double)minute);
    }

    public static Date addMinute(Date dt, long minute) {
        return CalenderKit.addMillisecond(dt, 60000L * minute);
    }

    public static Date addMinute(Date dt, double minute) {
        Double millisecond = new Double(60000.0 * minute);
        return CalenderKit.addMillisecond(dt, millisecond.longValue());
    }

    public static Date addHour(Date dt, int hour) {
        return CalenderKit.addHour(dt, (long)hour);
    }

    public static Date addHour(Date dt, float hour) {
        return CalenderKit.addHour(dt, (double)hour);
    }

    public static Date addHour(Date dt, long hour) {
        return CalenderKit.addMillisecond(dt, 3600000L * hour);
    }

    public static Date addHour(Date dt, double hour) {
        Double millisecond = new Double(3600000.0 * hour);
        return CalenderKit.addMillisecond(dt, millisecond.longValue());
    }

    public static Date addDay(Date dt, int day) {
        return CalenderKit.addDay(dt, (long)day);
    }

    public static Date addDay(Date dt, float day) {
        return CalenderKit.addDay(dt, (double)day);
    }

    public static Date addDay(Date dt, long day) {
        return CalenderKit.addMillisecond(dt, 86400000L * day);
    }

    public static Date addDay(Date dt, double day) {
        Double millisecond = new Double(8.64E7 * day);
        return CalenderKit.addMillisecond(dt, millisecond.longValue());
    }

    public static Date addMonth(Date dt, int month) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        cal.set(2, cal.get(2) + month);
        return cal.getTime();
    }

    public static Date addMonth(Date dt, float month) {
        return CalenderKit.addMonth(dt, (double)month);
    }

    public static Date addMonth(Date dt, long month) {
        return CalenderKit.addMonth(dt, new Long(month).intValue());
    }

    public static Date addMonth(Date dt, double month) {
        double floorMonth = Math.floor(month);
        double decimalMonth = month - floorMonth;
        dt = CalenderKit.addMonth(dt, new Double(floorMonth).intValue());
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        cal.set(2, cal.get(2) + 1);
        Date nextdt = cal.getTime();
        long monthMillisecond = nextdt.getTime() - dt.getTime();
        double millisecond = (double)monthMillisecond * decimalMonth;
        return CalenderKit.addMillisecond(dt, (long)millisecond);
    }

    public static Date addYear(Date dt, int year) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        cal.set(1, cal.get(1) + year);
        return cal.getTime();
    }

    public static Date addYear(Date dt, float year) {
        return CalenderKit.addYear(dt, (double)year);
    }

    public static Date addYear(Date dt, long year) {
        return CalenderKit.addYear(dt, new Long(year).intValue());
    }

    public static Date addYear(Date dt, double year) {
        double floorYear = Math.floor(year);
        double decimalYear = year - floorYear;
        dt = CalenderKit.addYear(dt, new Double(floorYear).intValue());
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        cal.set(1, cal.get(1) + 1);
        Date nextdt = cal.getTime();
        long yearMillisecond = nextdt.getTime() - dt.getTime();
        double millisecond = (double)yearMillisecond * decimalYear;
        return CalenderKit.addSecond(dt, (long)millisecond);
    }

    public static long getPeriodLong(int days, int hour, int minutes) {
        return (long)(days * 24 * 60 * 60) * 1000L + (long)(hour * 60 * 60) * 1000L + (long)(minutes * 60) * 1000L;
    }

    public static long getDays(long times) {
        return times / 86400000L;
    }

    public static long getHours(long times) {
        return times / 3600000L;
    }

    public static long getMinutes(long times) {
        return times / 60000L;
    }

    public static String getDHM(long times) {
        long hours = times % 86400000L;
        long minutes = hours % 3600000L;
        return String.valueOf(CalenderKit.getDays(times)) + "\u5929 " + String.valueOf(CalenderKit.getHours(hours)) + "\u5c0f\u65f6: " + String.valueOf(CalenderKit.getMinutes(minutes)) + "\u5206\u949f";
    }

    public static int getHour24OfTime(long time) {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date(time));
        return c.get(11);
    }

    public static int getMiniteOfTime(long time) {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date(time));
        return c.get(12);
    }

    public static int getSecondOfTime(long time) {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date(time));
        return c.get(13);
    }

    public static String getDuralTillNowString(long l) {
        long now = System.currentTimeMillis();
        long dural = now - l;
        if (dural < 600000L) {
            return "\u521a\u521a";
        }
        if (dural < 3600000L) {
            return dural / 600000L + "0 " + "\u5206\u949f\u524d";
        }
        if (dural < 18000000L) {
            return dural / 3600000L + "\u5c0f\u65f6\u524d";
        }
        if (l / 86400000L == now / 86400000L) {
            return "\u4eca\u5929";
        }
        Date theTime = new Date(l);
        Date nowTime = new Date(now);
        SimpleDateFormat sdf = null;
        String pattern = theTime.getYear() != nowTime.getYear() ? "yyyy-MM-dd" : "MM-dd";
        sdf = new SimpleDateFormat(pattern);
        String ret = sdf.format(l);
        if (ret.startsWith("0")) {
            ret = ret.substring(1);
        }
        return ret;
    }

    public static long getTimeLongFromDHM(int id, int ih, int im) {
        return (long)id * 24L * 60L * 60L * 1000L + (long)ih * 60L * 60L * 1000L + (long)im * 60L * 1000L;
    }

    public static long parseTimeString(String timeString, String pattern) {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        ParsePosition pos = new ParsePosition(0);
        Date date = formatter.parse(timeString, pos);
        return date.getTime();
    }

    public static void main(String[] args) {
        Date d = new Date();
        System.out.println(d);
        System.out.println(CalenderKit.convertDate2LocalDate(d));
        System.out.println(CalenderKit.convertDate2LocalDateTime(d));
        System.out.println(CalenderKit.convertLocalDate2Date(CalenderKit.convertDate2LocalDate(d)));
        System.out.println(CalenderKit.convertLocalDateTime2Date(CalenderKit.convertDate2LocalDateTime(d)));
    }
}

