package net.jplugin.core.das.dds.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import net.jplugin.core.das.dds.api.RouterException;
import net.jplugin.core.das.dds.api.RouterExecutionContext;
import net.jplugin.core.das.dds.api.IRouterDataSource.StatementResult;

public class DummyStatement extends EmptyStatement {

	protected DummyConnection connection;
	protected ExecuteResult executeResult = new ExecuteResult();

	public static Statement create(DummyConnection conn) {
		DummyStatement cs = new DummyStatement();
		cs.connection = conn;
		return cs;
	}

	@Override
	public final ResultSet executeQuery(String sql) throws SQLException {
		StatementResult r = genTargetNotPreparedStatement(connection, sql);
		Statement stmt = r.getStatement();
		sql = r.getResultSql();
		ResultSet rs = stmt.executeQuery(sql);

		return rs;
	}

	@Override
	public final int executeUpdate(String sql) throws SQLException {
		StatementResult r = genTargetNotPreparedStatement(connection, sql);
		Statement stmt = r.getStatement();
		sql = r.getResultSql();
		int cnt = stmt.executeUpdate(sql);

		return cnt;
	}

	@Override
	public final boolean execute(String sql) throws SQLException {
		StatementResult rr = genTargetNotPreparedStatement(connection, sql);
		Statement stmt = rr.getStatement();
		sql = rr.getResultSql();
		boolean r = stmt.execute(sql);

		return r;
	}

	@Override
	public final ResultSet getResultSet() throws SQLException {
		return executeResult.getResult();
	}

	@Override
	public final int getUpdateCount() throws SQLException {
		return executeResult.getUpdateCount();
	}

	@Override
	public final Connection getConnection() throws SQLException {
		return connection;
	}

	@Override
	public final int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
		StatementResult r = genTargetNotPreparedStatement(connection, sql);
		Statement stmt = r.getStatement();
		sql = r.getResultSql();
		int cnt = stmt.executeUpdate(sql, autoGeneratedKeys);

		return cnt;
	}

	@Override
	public final int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
		StatementResult r = genTargetNotPreparedStatement(connection, sql);
		Statement stmt = r.getStatement();
		sql = r.getResultSql();
		int cnt = stmt.executeUpdate(sql, columnIndexes);

		return cnt;
	}

	@Override
	public final int executeUpdate(String sql, String[] columnNames) throws SQLException {
		StatementResult r = genTargetNotPreparedStatement(connection, sql);
		Statement stmt = r.getStatement();
		sql = r.getResultSql();
		int cnt = stmt.executeUpdate(sql, columnNames);

		return cnt;
	}

	@Override
	public final boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
		StatementResult r = genTargetNotPreparedStatement(connection, sql);
		Statement stmt = r.getStatement();
		sql = r.getResultSql();
		boolean b = stmt.execute(sql, autoGeneratedKeys);
		return b;
	}

	@Override
	public final boolean execute(String sql, int[] columnIndexes) throws SQLException {
		StatementResult r = genTargetNotPreparedStatement(connection, sql);
		Statement stmt = r.getStatement();
		sql = r.getResultSql();
		boolean b = stmt.execute(sql, columnIndexes);
		return b;
	}

	@Override
	public final boolean execute(String sql, String[] columnNames) throws SQLException {
		StatementResult r = genTargetNotPreparedStatement(connection, sql);
		Statement stmt = r.getStatement();
		sql = r.getResultSql();
		boolean b = stmt.execute(sql, columnNames);
		return b;
	}

	@Override
	public final boolean isClosed() throws SQLException {
		return false;
	}

	@Override
	public final void close() throws SQLException {
		this.executeResult.clear();
	}

	@Override
	public final boolean getMoreResults() throws SQLException {
		return this.executeResult.getMoreResults();
	}

	/**
	 * 这个返回用来执行带sql参数的情况
	 * 
	 * @return
	 * @throws SQLException
	 */
	private StatementResult genTargetNotPreparedStatement(DummyConnection conn, String sql) throws SQLException {
		return (StatementResult) RouterExecutionContext.call(() -> {
			StatementResult stmtResult = conn.getDataSource().getTargetStmtBefExecute(this.connection.getDataSource(),
					sql);
			if (stmtResult == null)
				throw new RouterException("got null target stmt");

			Util.trySetConnection(stmtResult.getStatement(), this.connection);

			this.executeResult.set(stmtResult.getStatement());
			return stmtResult;
		});
	}

	@Override
	public ResultSet getGeneratedKeys() throws SQLException {
		return this.executeResult.getGeneratedKeys();
	}

}
