/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.cloud.rpc.server;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import java.net.UnknownHostException;
import java.util.Properties;
import net.jplugin.cloud.rpc.common.util.NetUtils;
import net.jplugin.cloud.rpc.server.imp.RpcServerManager;
import net.jplugin.core.config.api.CloudEnvironment;
import net.jplugin.core.kernel.api.AbstractPlugin;
import net.jplugin.core.kernel.api.PluginAnnotation;
import net.jplugin.core.kernel.api.PluginEnvirement;
import net.jplugin.core.service.api.RefService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginAnnotation
public class Plugin
extends AbstractPlugin {
    private static final Logger log = LoggerFactory.getLogger(Plugin.class);
    private static final String USERNAME = "nacos";
    private static final String PASSWORD = "nacos";
    private static final String NAMESPACE = "public";
    @RefService
    RpcServerManager server;

    public int getPrivority() {
        return -98;
    }

    public void init() {
        this.server.start();
        this.registerService();
    }

    private void registerService() {
        try {
            Properties properties = new Properties();
            properties.put("username", "nacos");
            properties.put("password", "nacos");
            properties.put("serverAddr", CloudEnvironment.INSTANCE.getNacosUrl());
            properties.put("namespace", NAMESPACE);
            NamingService namingService = NacosFactory.createNamingService((Properties)properties);
            Instance instance = new Instance();
            instance.setIp(this.getIp());
            instance.setPort(Integer.parseInt(CloudEnvironment.INSTANCE.getRpcPort()));
            instance.setHealthy(true);
            instance.setWeight(1.0);
            namingService.registerInstance(CloudEnvironment.INSTANCE._composeAppCode(), instance);
            PluginEnvirement.INSTANCE.getStartLogger().log((Object)("\u670d\u52a1\u5411Nacos\u6ce8\u518c\u5b8c\u6bd5:" + CloudEnvironment.INSTANCE._composeAppCode()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getIp() throws UnknownHostException {
        return NetUtils.getLocalIp();
    }
}

