/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.cloud.rpc.io.util;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.jplugin.cloud.rpc.common.config.AbstractConfig;
import net.jplugin.common.kits.ThreadFactoryBuilder;

public class ThreadPoolManager {
    private static ThreadPoolExecutor rpcWorkers;
    private static ThreadPoolExecutor respWorkers;
    private static ThreadPoolExecutor sendHeartWorkers;
    private static final Integer maxSize;
    public static volatile ThreadPoolManager INSTANCE;

    private ThreadPoolManager() {
    }

    public synchronized ThreadPoolExecutor getServerWorkers() {
        if (rpcWorkers == null) {
            int min = AbstractConfig.getRpcWorkers();
            int max = AbstractConfig.getMaxRpcWorkers();
            rpcWorkers = new ThreadPoolExecutor(min, max, 30L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(maxSize), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("esf-rpc-executor-%d").build());
        }
        return rpcWorkers;
    }

    public synchronized ThreadPoolExecutor getClientWorks() {
        if (respWorkers == null) {
            int respMin = AbstractConfig.getRpcRespWorkers();
            int respMax = AbstractConfig.getMaxRpcRespWorkers();
            respWorkers = new ThreadPoolExecutor(respMin, respMax, 30L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(maxSize), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("esf-rpc-responsor-%d").build());
        }
        return respWorkers;
    }

    public synchronized ThreadPoolExecutor getSendHeartWorkers() {
        if (sendHeartWorkers == null) {
            int respMin = AbstractConfig.getRpcRespWorkers();
            int respMax = AbstractConfig.getMaxRpcRespWorkers();
            sendHeartWorkers = new ThreadPoolExecutor(respMin, respMax, 30L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(maxSize), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("esf-sendHeart-executor-%d").build());
        }
        return sendHeartWorkers;
    }

    static {
        maxSize = 10000;
        INSTANCE = new ThreadPoolManager();
    }
}

