/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.cloud.rpc.io.util;

import net.jplugin.cloud.rpc.io.client.ClientChannelHandler;
import net.jplugin.cloud.rpc.io.client.NettyClient;
import net.jplugin.cloud.rpc.io.message.RpcMessage;
import net.jplugin.netty.io.netty.channel.Channel;
import net.jplugin.netty.io.netty.channel.ChannelHandlerContext;
import net.jplugin.netty.io.netty.util.Attribute;
import net.jplugin.netty.io.netty.util.AttributeKey;

public class ChannelAttributeUtil {
    private static AttributeKey CLIENT_CHANNEL_HANDLER = AttributeKey.newInstance("CLIENT_CHANNEL_HANDLER");
    private static AttributeKey CLIENT_INFO_MESSAGE = AttributeKey.newInstance("CLIENT_INFO_MESSAGE");
    private static AttributeKey SERVER_INFO_MESSAGE = AttributeKey.newInstance("SERVER_INFO_MESSAGE");
    private static AttributeKey NETTY_CLIENT = AttributeKey.newInstance("NETTY_CLIENT");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientChannelHandler getOrCreateClientChannelHandler(Channel channel) {
        Attribute<ClientChannelHandler> attr = channel.attr(CLIENT_CHANNEL_HANDLER);
        if (attr.get() == null) {
            Attribute<ClientChannelHandler> attribute = attr;
            synchronized (attribute) {
                if (attr.get() == null) {
                    ClientChannelHandler rpcChannel = new ClientChannelHandler(channel);
                    attr.set(rpcChannel);
                }
            }
        }
        return (ClientChannelHandler)((Object)attr.get());
    }

    public static void setClientInfo(ChannelHandlerContext channel, RpcMessage msg) {
        Attribute<RpcMessage> attr = channel.channel().attr(CLIENT_INFO_MESSAGE);
        if (attr.get() != null) {
            throw new RuntimeException("Client info already received!");
        }
        attr.set(msg);
    }

    public static void setServerInfo(ChannelHandlerContext channel, RpcMessage msg) {
        Attribute<RpcMessage> attr = channel.channel().attr(SERVER_INFO_MESSAGE);
        if (attr.get() != null) {
            throw new RuntimeException("Server info already received!");
        }
        attr.set(msg);
    }

    public static RpcMessage getClientInfo(ChannelHandlerContext ctx) {
        Attribute attr = ctx.channel().attr(CLIENT_INFO_MESSAGE);
        return (RpcMessage)attr.get();
    }

    public static void setNettyClient(Channel channel, NettyClient nettyClient) {
        Attribute<NettyClient> attr = channel.attr(NETTY_CLIENT);
        attr.set(nettyClient);
    }

    public static NettyClient getNettyClient(Channel channel) {
        Attribute attr = channel.attr(NETTY_CLIENT);
        return (NettyClient)attr.get();
    }
}

