/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.cloud.rpc.io.server;

import net.jplugin.cloud.rpc.io.handler.RpcMessageDecoder;
import net.jplugin.cloud.rpc.io.handler.RpcMessageEncoder;
import net.jplugin.cloud.rpc.io.handler.RpcServerMessageHandler;
import net.jplugin.common.kits.ThreadFactoryBuilder;
import net.jplugin.netty.io.netty.bootstrap.ServerBootstrap;
import net.jplugin.netty.io.netty.buffer.PooledByteBufAllocator;
import net.jplugin.netty.io.netty.channel.Channel;
import net.jplugin.netty.io.netty.channel.ChannelFuture;
import net.jplugin.netty.io.netty.channel.ChannelInitializer;
import net.jplugin.netty.io.netty.channel.ChannelOption;
import net.jplugin.netty.io.netty.channel.ChannelPipeline;
import net.jplugin.netty.io.netty.channel.nio.NioEventLoopGroup;
import net.jplugin.netty.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServer {
    protected Logger logger = LoggerFactory.getLogger(NettyServer.class);
    protected NioEventLoopGroup boss;
    protected NioEventLoopGroup workers;
    protected ServerBootstrap serverBoot;
    protected boolean closed;
    protected int serverPort;
    protected int bossThreads;
    protected int workerThreads;

    public NettyServer(int port, int boss, int workers) {
        this.serverPort = port;
        this.bossThreads = boss;
        this.workerThreads = workers;
    }

    public void boostrap() {
        this.closed = false;
        this.serverBoot = new ServerBootstrap();
        this.boss = new NioEventLoopGroup(this.bossThreads, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("nioEventLoop-nettyServer-boss-%d").build());
        this.workers = new NioEventLoopGroup(this.workerThreads, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("nioEventLoop-nettyServer-worker-%d").build());
        this.serverBoot.group(this.boss, this.workers);
        this.serverBoot.option(ChannelOption.SO_BACKLOG, 1024);
        this.serverBoot.option(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT);
        this.serverBoot.option(ChannelOption.SO_REUSEADDR, true);
        this.serverBoot.childOption(ChannelOption.SO_RCVBUF, 0x100000);
        this.serverBoot.childOption(ChannelOption.SO_SNDBUF, 0x100000);
        this.serverBoot.childOption(ChannelOption.TCP_NODELAY, true);
        this.serverBoot.childOption(ChannelOption.SO_KEEPALIVE, true);
        this.serverBoot.childOption(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT);
        this.serverBoot.channel(NioServerSocketChannel.class);
        this.serverBoot.childHandler(new ChannelInitializer(){

            protected void initChannel(Channel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new RpcMessageDecoder());
                pipeline.addLast(new RpcMessageEncoder());
                pipeline.addLast(new RpcServerMessageHandler());
            }
        });
        this.doBind();
    }

    public void destroy() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.boss != null) {
            this.boss.shutdownGracefully();
            this.boss = null;
        }
        if (this.workers != null) {
            this.workers.shutdownGracefully();
            this.workers = null;
        }
        if (this.serverBoot != null) {
            this.serverBoot = null;
        }
    }

    protected void doBind() {
        if (this.closed) {
            return;
        }
        ChannelFuture future = this.serverBoot.bind(this.serverPort);
        future.syncUninterruptibly();
        if (!future.isSuccess()) {
            throw new RuntimeException("ESF Server start failed, port bind error!", future.cause());
        }
    }
}

